% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerAvg.R
\name{mlr_learners_avg}
\alias{mlr_learners_avg}
\alias{LearnerClassifAvg}
\alias{mlr_learners_classif.avg}
\alias{LearnerRegrAvg}
\alias{mlr_learners_regr.avg}
\title{Optimized Weighted Average of Features for Classification and Regression}
\format{
\code{\link[R6:R6Class]{R6Class}} object inheriting from \code{\link[mlr3:LearnerClassif]{mlr3::LearnerClassif}}/\code{\link[mlr3:Learner]{mlr3::Learner}}.
}
\usage{
mlr_learners_classif.avg

mlr_learners_regr.avg
}
\description{
Computes a weighted average of inputs.
Used in the context of computing weighted averages of predictions.

Predictions are averaged using \code{weights} (in order of appearance in the data) which are optimized using
nonlinear optimization from the package \CRANpkg{nloptr} for a measure provided in
\code{measure}. (defaults to \code{classif.ce} for \code{LearnerClassifAvg} and \code{regr.mse} for \code{LearnerRegrAvg}).
Learned weights can be obtained from \verb{$model}.
This Learner implements and generalizes an approach proposed in LeDell (2015) that uses non-linear
optimization in order to learn base-learner weights that optimize a given performance metric (e.g \code{AUC}).
The approach is similar but not exactly the same as the one implemented as \code{AUC} in the \CRANpkg{SuperLearner}
R package (when \code{metric} is \code{"classif.auc"}).
For a more detailed analysis and the general idea, the reader is referred to LeDell (2015).

Note, that weights always sum to 1 by division by \code{sum(weights)} before weighting
incoming features.
}
\section{Parameters}{

The parameters are the parameters inherited from \code{\link[mlr3:LearnerClassif]{LearnerClassif}}, as well as:
\itemize{
\item \code{measure} :: \code{\link[mlr3:Measure]{Measure}} | \code{character} \cr
\code{\link[mlr3:Measure]{Measure}} to optimize for.
Will be converted to a \code{\link[mlr3:Measure]{Measure}} in case it is \code{character}.
Initialized to \code{"classif.ce"}, i.e. misclassification error for classification
and \code{"regr.mse"}, i.e. mean squared error for regression.
\item \code{optimizer} :: \code{\link[bbotk:Optimizer]{Optimizer}} | \code{character(1)}\cr
\code{\link[bbotk:Optimizer]{Optimizer}} used to find optimal thresholds.
If \code{character}, converts to \code{\link[bbotk:Optimizer]{Optimizer}}
via \code{\link[bbotk:opt]{opt}}. Initialized to \code{OptimizerNLoptr}.
Nloptr hyperparameters are initialized to \code{xtol_rel = 1e-8}, \code{algorithm = "NLOPT_LN_COBYLA"}
and equal initial weights for each learner.
For more fine-grained control, it is recommended to supply a instantiated \code{\link[bbotk:Optimizer]{Optimizer}}.
\item \code{log_level} :: \code{character(1)} | \code{integer(1)}\cr
Set a temporary log-level for \code{lgr::get_logger("bbotk")}. Initialized to: "warn".
}
}

\section{Methods}{

\itemize{
\item \verb{LearnerClassifAvg$new(), id = "classif.avg")} \cr
(\code{chr}) -> \code{self} \cr
Constructor.
\item \verb{LearnerRegrAvg$new(), id = "regr.avg")} \cr
(\code{chr}) -> \code{self} \cr
Constructor.
}
}

\references{
LeDell, Erin (2015).
\emph{Scalable Ensemble Learning and Computationally Efficient Variance Estimation}.
Ph.D. thesis, UC Berkeley.
}
\seealso{
Other Learners: 
\code{\link{mlr_learners_graph}}

Other Ensembles: 
\code{\link{PipeOpEnsemble}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_regravg}}
}
\concept{Ensembles}
\concept{Learners}
