% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compas.R
\docType{data}
\name{compas}
\alias{compas}
\alias{Compas}
\title{COMPAS Dataset}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link{TaskClassif}.

\link[R6:R6Class]{R6::R6Class} inheriting from \link{TaskClassif}.
}
\source{
ProPublica Analysis: \url{https://github.com/propublica/compas-analysis}

Bao, Michelle, Zhou, Angela, Zottola, A S, Brubach, Brian, Desmarais, Sarah, Horowitz, Seth A, Lum, Kristian, Venkatasubramanian, Suresh (2021).
\dQuote{It's COMPASlicated: The Messy Relationship between RAI Datasets and Algorithmic Fairness Benchmarks.}
In \emph{Thirty-fifth Conference on Neural Information Processing Systems Datasets and Benchmarks Track (Round 1)}.
}
\description{
The COMPAS dataset includes the processed COMPAS data between 2013-2014.
The data cleaning process followed the guidance in the original COMPAS repo.
Contains 6172 observations and 14 features.
The target column could either be "is_recid" or "two_year_recid", but often "two_year_recid" is prefered.
The column \code{"sex"} is set as protected attribute, but more often \code{"race"} is used.

Derived tasks: \cr
\itemize{
\item \code{compas} : A classification task for the \link{compas} data set with the protected attribute 'sex'.
}

\itemize{
\item \code{compas_race_binary} : A classification task for the \link{compas} data set with the protected attribute 'race'.
The observations have been filtered, keeping only observations with race
\code{"Caucasian"} and \code{"African-American"}. The protected attribute has been set
to \code{"race"}.
}
}
\section{Using COMPAS - Known Problems}{

The COMPAS dataset was collected as part of the ProPublica analysis of machine bias in criminal sentencing.
It is important to note, that using COMPAS is generally discouraged for the following reasons:
\itemize{
\item The prediction task derived from this dataset has little connection to actually relevant tasks in the
context of risk assessment instruments.
\item Collected data and labels suffer from disparate measurement bias.
}

The dataset should therefore not be used to benchmark new fairness algorithms or measures.
For a more in-depth treatment, see Bao et al., 2021: It's COMPASlicated: The Messy Relationship between RAI Datasets and Algorithmic Fairness Benchmarks.
We replicate the dataset here to raise awareness for this issue.
Furthermore, similar issues exist across a wide variety of datasets widely used in the context of fairness auditing
and we, therefore, consider issues, e.g. derived from disparate measurement bias an important issue in the context of fairness audits.
}

\section{Pre-processing}{

\itemize{
\item Identifying columns are removed
\item Removed the outliers for abs(days_b_screening_arrest) >= 30.
\item Removed observations where is_recid != -1.
\item Removed observations where c_charge_degree != "O".
\item Removed observations where score_text != 'N/A'.
\item Factorize the features that are categorical.
\item Add length of stay (c_jail_out - c_jail_in) in the dataset.
\item \verb{Pre-processing Resource:} @url https://github.com/propublica/compas-analysis/blob/master/Compas\%20Analysis.ipynb
}
}

\section{Metadata}{

\itemize{
\item (integer) age : The age of defendants.
\item (factor) c_charge_degree : The charge degree of defendants. F: Felony M: Misdemeanor
\item (factor) race: The race of defendants.
\item (factor) age_cat: The age category of defendants.
\item (factor) score_text: The score category of defendants.
\item (factor) sex: The sex of defendants.
\item (integer) priors_count: The prior criminal records of defendants.
\item (integer) days_b_screening_arrest: The count of days between screening date and (original) arrest date.
If they are too far apart, that may indicate an error. If the value is negative,
that indicate the screening date happened before the arrest date.
\item (integer) decile_score: Indicate the risk of recidivism (Min=1, Max=10)
\item (integer) is_recid: Binary variable indicate whether defendant is rearrested at any time.
\item (factor) two_year_recid: Binary variable indicate whether defendant is rearrested at within two years.
\item (numeric) length_of_stay: The count of days stay in jail.
}
}

\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_tasks$get("compas")
tsk("compas")
}\if{html}{\out{</div>}}



\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_tasks$get("compas_race_binary")
tsk("compas_race_binary")
}\if{html}{\out{</div>}}
}

\examples{
library("mlr3")
data("compas", package = "mlr3fairness")
}
\keyword{data}
