% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClassifDebug.R
\docType{data}
\name{LearnerClassifDebug}
\alias{LearnerClassifDebug}
\alias{mlr_learners_classif.debug}
\title{Classification Learner for Debugging}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{LearnerClassif}.}
\usage{
LearnerClassifDebug
}
\description{
A simple \link{LearnerClassif} used primarily in the unit tests and for debugging purposes.
If no hyperparameter is set, it simply constantly predicts a randomly selected label.
The following hyperparameters trigger the following actions:
\describe{
\item{message_train:}{Outputs a message during train if \code{runif(1)} exceeds its value.}
\item{message_predict:}{Outputs a message during predict if \code{runif(1)} exceeds its value.}
\item{warning_train:}{Signals a warning during train if \code{runif(1)} exceeds its value.}
\item{warning_predict:}{Signals a warning during predict if \code{runif(1)} exceeds its value.}
\item{error_train:}{Raises an exception during train if \code{runif(1)} exceeds its value.}
\item{error_predict:}{Raises an exception during predict if \code{runif(1)} exceeds its value.}
\item{segfault_train:}{Provokes a segfault during train if \code{runif(1)} exceeds its value.}
\item{segfault_predict:}{Provokes a segfault during predict if \code{runif(1)} exceeds its value.}
\item{predict_missing}{Ratio of predictions which will be NA.}
\item{save_tasks:}{Saves input task in \code{model} slot during training and prediction.}
\item{x:}{Numeric parameter. Ignored.}
}
Note that segfaults may not work on your operating system.
Also note that if they work, they will tear down your R session immediately!
}
\examples{
learner = LearnerClassifDebug$new()
learner$param_set$values = list(message_train = 1, save_tasks = TRUE)

# this should signal a message
task = mlr_tasks$get("iris")
learner$train(task)
learner$predict(task)

# task_train and task_predict are the input tasks for train() and predict()
names(learner$model)
}
\keyword{datasets}
