% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parms.mkinfit.R
\name{parms}
\alias{parms}
\alias{parms.mkinfit}
\title{Extract model parameters from mkinfit models}
\usage{
parms(object, ...)

\method{parms}{mkinfit}(object, transformed = FALSE, ...)
}
\arguments{
\item{object}{A fitted model object}

\item{\dots}{Not used}

\item{transformed}{Should the parameters be returned
as used internally during the optimisation?}
}
\value{
A numeric vector of fitted model parameters
}
\description{
This function always returns degradation model parameters as well as error
model parameters, in order to avoid working with a fitted model without
considering the error structure that was assumed for the fit.
}
\examples{
fit <- mkinfit("SFO", FOCUS_2006_C)
parms(fit)
parms(fit, transformed = TRUE)
}
