% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-management.R
\name{gtrack.dbs}
\alias{gtrack.dbs}
\title{Returns the database paths that contain track(s)}
\usage{
gtrack.dbs(track = NULL, dataframe = FALSE)
}
\arguments{
\item{track}{track name or a vector of track names}

\item{dataframe}{return a data frame with columns \code{track} and \code{db}
instead of a named character vector.}
}
\value{
A named character vector of database paths for each track. If
\code{dataframe} is TRUE, returns a data frame with columns \code{track} and
\code{db}, with multiple rows per track when it appears in multiple databases.
}
\description{
Returns all database paths that contain a version of a track.
}
\details{
When datasets are loaded, a track may exist in multiple locations (working
database and/or datasets). This function computes on-demand and returns all
such paths, which is useful for debugging when using \code{force=TRUE} with
\code{gdataset.load()}.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gtrack.dbs("dense_track")
gtrack.dbs(gtrack.ls(), dataframe = TRUE)

}
\seealso{
\code{\link{gtrack.dataset}}, \code{\link{gtrack.exists}},
\code{\link{gtrack.ls}}, \code{\link{gdataset.ls}}
}
\keyword{~database}
\keyword{~path}
\keyword{~track}
