% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss.glm.control.R
\name{miss.glm.control}
\alias{miss.glm.control}
\title{Auxiliary for Controlling Fitting}
\usage{
miss.glm.control(
  maxruns = 500,
  tol_em = 1e-07,
  nmcmc = 2,
  tau = 1,
  k1 = 50,
  subsets = NA,
  seed = NA,
  print_iter = TRUE,
  var_cal = TRUE,
  ll_obs_cal = TRUE
)
}
\arguments{
\item{maxruns}{maximum number of iterations. The default is maxruns = 500.}

\item{tol_em}{the tolerance to stop SAEM. The default is tol_em = 1e-7.}

\item{nmcmc}{the MCMC length. The default is nmcmc = 2.}

\item{tau}{rate \eqn{\tau}{\tau} in the step size \eqn{(k-k_{1})^{-\tau}}{(k-k1)^(-\tau)}. The default is tau = 1.}

\item{k1}{number of first iterations \eqn{k_{1}}{k1} in the step size \eqn{(k-k_{1})^{-\tau}}{(k-k1)^(-\tau)}. The default is k1=50.}

\item{subsets}{Index of selected covariates if any. The default is all the covariates.}

\item{seed}{an integer as a seed set for the random generator.}

\item{print_iter}{logical indicating if output should be produced for each iteration.}

\item{var_cal}{logical indicating if the variance of estimated parameters should be calculated.}

\item{ll_obs_cal}{logical indicating if the observed log-likelihood should be calculated.}
}
\value{
A list with components named as the arguments.
}
\description{
Auxiliary function for \code{\link{miss.glm}} fitting. Typically only used internally by \code{\link{miss.glm.fit}}.
}
\examples{
## For examples see example(miss.glm)
}
