% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod2values.R
\name{mod2values}
\alias{mod2values}
\title{Convert an estimated mirt model to a data.frame}
\usage{
mod2values(x)
}
\arguments{
\item{x}{an estimated model x from the mirt package}
}
\description{
Given an estimated model from any of mirt's model fitting functions this function will convert
the model parameters into the design data frame of starting values and other parameter
characteristics (similar to using the \code{pars = 'values'} for obtaining starting values).
}
\examples{

\dontrun{
dat <- expand.table(LSAT7)
mod <- mirt(dat, "F=1-5
                  CONSTRAIN=(1-5, a1)")
values <- mod2values(mod)
values

# use the converted values as starting values in a new model, and reduce TOL
mod2 <- mirt(dat, 1, pars = values, TOL=1e-5)
coef(mod2, simplify=TRUE)

# use parameters on different dataset
mod3 <- mirt(expand.table(LSAT6), pars=values)
coef(mod3, simplify=TRUE)

# supports differing itemtypes on second model
sv <- mirt(Science, itemtype=c('graded', rep('gpcm', 3)), pars='values')
mod3 <- mirt(Science, pars = sv)  # itemtype omitted
coef(mod3, simplify=TRUE)$items
extract.mirt(mod3, 'itemtype')


}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\seealso{
\code{\link{extract.mirt}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{convert}
\keyword{model}
