% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_rxx.R
\name{marginal_rxx}
\alias{marginal_rxx}
\title{Function to calculate the marginal reliability}
\usage{
marginal_rxx(mod, density = dnorm, ...)
}
\arguments{
\item{mod}{an object of class \code{'SingleGroupClass'}}

\item{density}{a density function to use for integration. Default assumes the latent traits are from a
normal (Gaussian) distribution}

\item{...}{additional arguments passed to the density function}
}
\description{
Given an estimated model and a prior density function, compute the marginal reliability
(Thissen and Wainer, 2001). This is only available for unidimensional tests.
}
\examples{


dat <- expand.table(deAyala)
mod <- mirt(dat)

# marginal estimate treating item parameters as known
marginal_rxx(mod)

# compare to alpha
itemstats(dat)$overall$alpha

\dontrun{

# empirical estimate (assuming the same prior)
fscores(mod, returnER = TRUE)

# empirical rxx the alternative way, given theta scores and SEs
fs <- fscores(mod, full.scores.SE=TRUE)
head(fs)
empirical_rxx(fs)

}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}

Thissen, D. and Wainer, H. (2001). Test Scoring. Lawrence Erlbaum Associates.
}
\seealso{
\code{\link{empirical_rxx}}, \code{\link{extract.group}}, \code{\link{testinfo}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{reliability}
