% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleGroup-methods.R
\docType{methods}
\name{summary-method}
\alias{summary-method}
\alias{summary,SingleGroupClass-method}
\alias{summary,MultipleGroupClass-method}
\alias{summary,MixedClass-method}
\alias{summary,DiscreteClass-method}
\title{Summary of model object}
\usage{
\S4method{summary}{SingleGroupClass}(object, rotate = "oblimin",
  Target = NULL, suppress = 0, verbose = TRUE, ...)
}
\arguments{
\item{object}{an object of class \code{SingleGroupClass},
\code{MultipleGroupClass}, or \code{MixedClass}}

\item{rotate}{a string indicating which rotation to use for exploratory models, primarily
  from the \code{GPArotation} package (see documentation therein).

  Rotations currently supported are: \code{'promax'}, \code{'oblimin'}, \code{'varimax'},
  \code{'quartimin'}, \code{'targetT'}, \code{'targetQ'}, \code{'pstT'}, \code{'pstQ'},
  \code{'oblimax'}, \code{'entropy'}, \code{'quartimax'}, \code{'simplimax'},
  \code{'bentlerT'}, \code{'bentlerQ'}, \code{'tandemI'}, \code{'tandemII'},
  \code{'geominT'}, \code{'geominQ'}, \code{'cfT'}, \code{'cfQ'}, \code{'infomaxT'},
  \code{'infomaxQ'}, \code{'mccammon'}, \code{'bifactorT'}, \code{'bifactorQ'}.

  For models that are not exploratory this input will automatically be set to \code{'none'}}

\item{Target}{a dummy variable matrix indicting a target rotation pattern. This is required for
rotations such as \code{'targetT'}, \code{'targetQ'}, \code{'pstT'}, and \code{'pstQ'}}

\item{suppress}{a numeric value indicating which (possibly rotated) factor
loadings should be suppressed. Typical values are around .3 in most
statistical software. Default is 0 for no suppression}

\item{verbose}{logical; allow information to be printed to the console?}

\item{...}{additional arguments to be passed}
}
\description{
Transforms coefficients into a standardized factor loading's metric. For \code{MixedClass} objects,
the fixed and random coefficients are printed. Note that while the output to the console is rounded
to three digits, the returned list of objects is not. For simulations, use
\code{output <- summary(mod, verbose = FALSE)} to suppress the console messages.
}
\examples{

\dontrun{
x <- mirt(Science, 2)
summary(x)
summary(x, rotate = 'varimax')

}
}
\seealso{
\code{\link{coef-method}}
}
