% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai-package.R
\docType{package}
\encoding{UTF-8}
\name{mirai-package}
\alias{mirai-package}
\title{mirai: Minimalist Async Evaluation Framework for R}
\description{
Lightweight parallel code execution and distributed computing. Designed for
    simplicity, a 'mirai' evaluates an R expression asynchronously, on local
    or network resources, resolving automatically upon completion. State of
    the art networking and concurrency via 'nanonext' and 'NNG' (Nanomsg Next
    Gen) offers reliable and efficient scheduling over fast inter-process
    communications or TCP/IP secured by TLS.
}
\section{Notes}{


    For local mirai requests, the default transport for inter-process
    communications is platform-dependent: abstract Unix domain sockets on
    Linux, Unix domain sockets on MacOS, Solaris and other POSIX platforms,
    and named pipes on Windows.

    This may be overriden, if desired, by specifying 'url' in the
    \code{\link{daemons}} interface and launching daemons using
    \code{\link{launch_local}}.
}

\section{Reference Manual}{


\code{vignette("mirai", package = "mirai")}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://shikokuchuo.net/mirai/}
  \item \url{https://github.com/shikokuchuo/mirai/}
  \item Report bugs at \url{https://github.com/shikokuchuo/mirai/issues}
}

}
\author{
Charlie Gao \email{charlie.gao@shikokuchuo.net}
    (\href{https://orcid.org/0000-0002-0750-061X}{ORCID})
}
