% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_features.R
\name{features}
\alias{features}
\alias{network_core}
\alias{network_richclub}
\alias{network_factions}
\alias{network_modularity}
\alias{network_smallworld}
\alias{network_scalefree}
\alias{network_balance}
\title{Measures of network topological features}
\source{
\code{{signnet}} by David Schoch
}
\usage{
network_core(.data, membership = NULL)

network_richclub(.data)

network_factions(.data, membership = NULL)

network_modularity(.data, membership = NULL, resolution = 1)

network_smallworld(.data, method = c("omega", "sigma", "SWI"), times = 100)

network_scalefree(.data)

network_balance(.data)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{membership}{A vector of partition membership.}

\item{resolution}{A proportion indicating the resolution scale.
By default 1.}

\item{method}{There are three small-world measures implemented:
\itemize{
\item "sigma" is the original equation from Watts and Strogatz (1998),
\deqn{\frac{\frac{C}{C_r}}{\frac{L}{L_r}}},
where \eqn{C} and \eqn{L} are the observed
clustering coefficient and path length, respectively,
and \eqn{C_r} and \eqn{L_r} are the averages obtained from
random networks of the same dimensions and density.
A \eqn{\sigma > 1} is considered to be small-world,
but this measure is highly sensitive to network size.
\item "omega" (the default) is an update from Telesford et al. (2011),
\deqn{\frac{L_r}{L} - \frac{C}{C_l}},
where \eqn{C_l} is the clustering coefficient for a lattice graph
with the same dimensions.
\eqn{\omega} ranges between 0 and 1,
where 1 is as close to a small-world as possible.
\item "SWI" is an alternative proposed by Neal (2017),
\deqn{\frac{L - L_l}{L_r - L_l} \times \frac{C - C_r}{C_l - C_r}},
where \eqn{L_l} is the average path length for a lattice graph
with the same dimensions.
\eqn{SWI} also ranges between 0 and 1 with the same interpretation,
but where there may not be a network for which \eqn{SWI = 1}.
}}

\item{times}{Integer of number of simulations.}
}
\description{
These functions measure certain topological features of networks:
\itemize{
\item \code{network_core()} measures the correlation between a network
and a core-periphery model with the same dimensions.
\item \code{network_richclub()} measures the rich-club coefficient of a network.
\item \code{network_factions()} measures the correlation between a network
and a component model with the same dimensions.
If no 'membership' vector is given for the data,
\code{node_kernighanlin()} is used to partition nodes into two groups.
\item \code{network_modularity()} measures the modularity of a network
based on nodes' membership in defined clusters.
\item \code{network_smallworld()} measures the small-world coefficient for one- or
two-mode networks. Small-world networks can be highly clustered and yet
have short path lengths.
\item \code{network_scalefree()} measures the exponent of a fitted
power-law distribution. An exponent between 2 and 3 usually indicates
a power-law distribution.
\item \code{network_balance()} measures the structural balance index on
the proportion of balanced triangles,
ranging between \code{0} if all triangles are imbalanced and
\code{1} if all triangles are balanced.
\item \code{network_change()} measures the Hamming distance between two or more networks.
\item \code{network_stability()} measures the Jaccard index of stability between two or more networks.
}

These \verb{network_*()} functions return a single numeric scalar or value.
}
\section{Modularity}{

Modularity measures the difference between the number of ties within each community
from the number of ties expected within each community in a random graph
with the same degrees, and ranges between -1 and +1.
Modularity scores of +1 mean that ties only appear within communities,
while -1 would mean that ties only appear between communities.
A score of 0 would mean that ties are half within and half between communities,
as one would expect in a random graph.

Modularity faces a difficult problem known as the resolution limit
(Fortunato and Barthélemy 2007).
This problem appears when optimising modularity,
particularly with large networks or depending on the degree of interconnectedness,
can miss small clusters that 'hide' inside larger clusters.
In the extreme case, this can be where they are only connected
to the rest of the network through a single tie.
}

\examples{
network_core(ison_adolescents)
network_core(ison_southern_women)
network_richclub(ison_adolescents)
  network_factions(mpn_elite_mex)
  network_factions(ison_southern_women)
network_modularity(ison_adolescents, 
  node_kernighanlin(ison_adolescents))
network_modularity(ison_southern_women, 
  node_kernighanlin(ison_southern_women))
network_smallworld(ison_brandes)
network_smallworld(ison_southern_women)
network_scalefree(ison_adolescents)
network_scalefree(generate_scalefree(50, 1.5))
network_scalefree(create_lattice(100))
network_balance(ison_marvel_relationships)
}
\references{
Borgatti, Stephen P., and Martin G. Everett. 2000.
“Models of Core/Periphery Structures.”
\emph{Social Networks} 21(4):375–95.
\doi{10.1016/S0378-8733(99)00019-2}

Murata, Tsuyoshi. 2010. Modularity for Bipartite Networks.
In: Memon, N., Xu, J., Hicks, D., Chen, H. (eds)
\emph{Data Mining for Social Network Data. Annals of Information Systems}, Vol 12.
Springer, Boston, MA.
\doi{10.1007/978-1-4419-6287-4_7}

Watts, Duncan J., and Steven H. Strogatz. 1998.
“Collective Dynamics of ‘Small-World’ Networks.”
\emph{Nature} 393(6684):440–42.
\doi{10.1038/30918}.

Telesford QK, Joyce KE, Hayasaka S, Burdette JH, Laurienti PJ. 2011.
"The ubiquity of small-world networks".
\emph{Brain Connectivity} 1(5): 367–75.
\doi{10.1089/brain.2011.0038}.

Neal Zachary P. 2017.
"How small is it? Comparing indices of small worldliness".
\emph{Network Science}. 5 (1): 30–44.
\doi{10.1017/nws.2017.5}.
}
\seealso{
\code{\link[=network_transitivity]{network_transitivity()}} and \code{\link[=network_equivalency]{network_equivalency()}}
for how clustering is calculated

Other measures: 
\code{\link{between_centrality}},
\code{\link{close_centrality}},
\code{\link{closure}},
\code{\link{cohesion}()},
\code{\link{degree_centrality}},
\code{\link{eigenv_centrality}},
\code{\link{heterogeneity}},
\code{\link{hierarchy}},
\code{\link{holes}},
\code{\link{net_diffusion}},
\code{\link{node_diffusion}},
\code{\link{periods}}
}
\concept{measures}
