% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankTimePoints.R
\name{getTimeChoicePerformance}
\alias{getTimeChoicePerformance}
\title{estimate the distance between population average  an average over sample datasets with given time points (zero point included)}
\usage{
getTimeChoicePerformance(timePointInd, pkData, popAvCurve, timeGrid,
  printMCError = FALSE)
}
\arguments{
\item{timePointInd}{a vector indicating time points indicator selection of time points from fullTimePoints}

\item{pkData}{\code{\link{PkData-class}}}

\item{popAvCurve}{an interpolated population average curve}

\item{timeGrid}{the grid point at which to interpolate the curve}

\item{printMCError}{logical indicater when true the MC error is printed to the terminal, defaults to FALSE}
}
\value{
numeric value of the timePoint choice performance
}
\description{
estimate the distance between population average  an average over sample datasets with given time points (zero point included)
}
\examples{
 # get example inputs
 fullPkData                 <-  getExampleTimeData() # PkData object
 fullTimePoints             <-  getTimePoints(fullPkData)
 examplePopAvCurve          <-  fullTimePoints^2 
 timePointIndicators        <-  c( 1 , 5, 21 ) # zero point included
 nGridPoints                <-  25
 timeGrid                   <-  seq( min( fullTimePoints ),
    max( fullTimePoints ) , length.out = nGridPoints ) 
 popCurveInterpolated       <-  microsamplingDesign:::interpolateVec( fullTimePoints ,
   examplePopAvCurve,  timeGrid )

 getTimeChoicePerformance( timePointInd = timePointIndicators, pkData = fullPkData ,
   popAvCurve = popCurveInterpolated, timeGrid ) 

 getTimeChoicePerformance( timePointInd = timePointIndicators, pkData = fullPkData ,
   popAvCurve = popCurveInterpolated, timeGrid, printMCError = TRUE ) 

}
