% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/multiLinker.R
\name{multiLinker}
\alias{multiLinker}
\title{Run multiple simulations and calculations to test metric + null performance}
\usage{
multiLinker(no.taxa, arena.length, mean.log.individuals, length.parameter,
  sd.parameter, max.distance, proportion.killed, competition.iterations,
  no.plots, plot.length, concat.by, randomizations, cores, iterations, prefix,
  simulations, nulls, metrics)
}
\arguments{
\item{no.taxa}{The desired number of species in the input phylogeny}

\item{arena.length}{A numeric, specifying the length of a single side of the arena}

\item{mean.log.individuals}{Mean log of abundance vector from which species abundances
will be drawn}

\item{length.parameter}{Length of vector from which species' locations are drawn. Large
values of this parameter dramatically decrease the speed of the function but result in
nicer looking communities}

\item{sd.parameter}{Standard deviation of vector from which species' locations are
drawn}

\item{max.distance}{The geographic distance within which neighboring
indivduals should be considered to influence the individual in question}

\item{proportion.killed}{The percent of individuals in the total arena that should be
considered (as a proportion, e.g. 0.5 = half)}

\item{competition.iterations}{Number of generations over which to run competition
simulations}

\item{no.plots}{Number of plots to place}

\item{plot.length}{Length of one side of desired plot}

\item{concat.by}{Whether to concatenate the randomizations by richness, plot or both}

\item{randomizations}{The number of randomized CDMs, per null, to generate. These are
used to compare the significance of the observed metric scores.}

\item{cores}{The number of cores to be used for parallel processing.}

\item{iterations}{The number of complete tests to be run. For instance, 1 iteration
would be considered a complete cycle of running all spatial simulations, randomly
placing plots in the arenas, sampling the contents, creating a community data
matrix, calculating observed metric scores, then comparing these to the specified
number of randomizations of the original CDMs.}

\item{prefix}{Optional character vector to affix to the output RData file names, e.g.
"test1".}

\item{simulations}{Optional list of named spatial simulation functions to use. These
must be defined in the defineSimulations function. If invoked, this option will likely
be used to run a subset of the defined spatial simulations.}

\item{nulls}{Optional list of named null model functions to use. If invoked, this
option will likely be used to run a subset of the defined null models.}

\item{metrics}{Optional list of named metric functions to use. If invoked, this option
will likely be used to run a subset of the defined metrics.}
}
\value{
A list of lists of data frames. The first level of the output has one element
for each simulation. The second level has one element for each null model. Each of
these elements is a list of two data frames, one that summarizes the plot-level
significance and another and arena-level significance.
}
\description{
This function runs multiple iterations of the linker function, saving results to file.
}
\details{
This function wraps a number of other wrapper functions into
one big metric + null performance tester function. Unlike the basic linker function,
multiple tests can be run, with results saved as RDS files.
}
\examples{
#not run
#system.time(multiLinker(no.taxa=50, arena.length=300, mean.log.individuals=3.2,
	#length.parameter=5000, sd.parameter=50, max.distance=20, proportion.killed=0.3,
	#competition.iterations=2, no.plots=20, plot.length=30, concat.by="richness",
	#randomizations=3, cores=1, iterations=2, prefix="test",
	#nulls=list("richness"=metricTester:::my_richnessNull,
	#"frequency"=metricTester:::my_frequency)))
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

