% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeteorologyUncorrectedData.R
\name{MeteorologyUncorrectedData}
\alias{MeteorologyUncorrectedData}
\title{Creates an object of class 'MeteorologyUncorrectedData'}
\usage{
MeteorologyUncorrectedData(
  points,
  reference_data,
  projection_data,
  dates,
  params = defaultCorrectionParams()
)
}
\arguments{
\item{points}{An object of class \code{SpatialPoints}.}

\item{reference_data}{Reference (historic) meteorological data used to
calibrate correction factors when compared with observations. A vector of
data frames (one per point) or a single data frame containing the meta data
(columns \code{dir} and \code{filename}) of meteorological files that will
be read from the disk. Alternatively, a NetCDF file name where points should
be read.}

\item{projection_data}{Projected meteorological data to be corrected. A
vector of data frames (one per point) or a single data frame containing the
meta data (columns \code{dir} and \code{filename}) of meteorological files
that will be read from the disk. Alternatively, a NetCDF file name where
points should be read.}

\item{dates}{Object of class \code{"Date"} describing the time period for
which meteorological correction is possible (corresponding to
\code{projection_data}).}

\item{params}{A \code{"list"} containing correction parameters.}
}
\value{
An object of class \code{\linkS4class{MeteorologyUncorrectedData}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Initializes an object for statistical correction of meteorological data over
landscapes.
}
\details{
See correction details in vignettes or in \code{\link{correctionpoints}}.
}
\seealso{
\code{\linkS4class{MeteorologyUncorrectedData}},
\code{\link{defaultCorrectionParams}}.
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
