% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_pred.R
\name{select_pred}
\alias{select_pred}
\title{Selects a best subset of predictor variables.}
\usage{
select_pred(.data, resp, covariates = NULL, npred)
}
\arguments{
\item{.data}{A data frame with the response variable and covariates.}

\item{resp}{The response variable.}

\item{covariates}{The covariates. Defaults to \emph{NULL}. In this case, all
numeric traits in \code{.data}, except that in \code{resp} are selected. To
select specific covariates from \code{.data}, use a list of unquoted
comma-separated variable names (e.g. \emph{traits = c(var1, var2, var3)}),
an specific range of variables, (e.g. \emph{traits = c(var1:var3)}), or
even a select helper like \code{starts_with("N")}.}

\item{npred}{An integer specifying the size of the subset of predictors to be
selected}
}
\value{
A list with the following elements:
\itemize{
\item \strong{sel_mod} An object of class \code{lm} that is the selected model.
\item \strong{predictors} The name of the selected predictors.
\item \strong{AIC} The Akaike's Information Criterion for the selected model.
\item \strong{pred_models} The Akaike's Information Criterion and the predictors
selected in each step.
\item \strong{predicted} The predicted values considering the model in
\code{sel_mod}.
}
}
\description{
Selects among a set of \code{covariates} the best set of \code{npred}
predictors for a given response trait \code{resp} based on AIC values.
}
\examples{
\donttest{
library(metan)
mod <- select_pred(data_ge2, resp = PH, npred = 10)
mod$predictors
mod$AIC
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
