% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Smith_Hazel.R
\name{print.sh}
\alias{print.sh}
\title{Print an object of class sh}
\usage{
\method{print}{sh}(x, export = FALSE, file.name = NULL, digits = 4, ...)
}
\arguments{
\item{x}{An object of class \code{sh}.}

\item{export}{A logical argument. If \code{TRUE}, a *.txt file is exported
to the working directory}

\item{file.name}{The name of the file if \code{export = TRUE}}

\item{digits}{The significant digits to be shown.}

\item{...}{Options used by the tibble package to format the output. See
\code{\link[tibble:formatting]{tibble::print()}} for more details.}
}
\description{
Print a \code{sh} object in two ways. By default, the results are shown in
the R console. The results can also be exported to the directory.
}
\examples{
\donttest{
vcov <- covcor_design(data_g, GEN, REP, everything())
means <- as.matrix(vcov$means)
pcov <- vcov$phen_cov
gcov <- vcov$geno_cov

index <- Smith_Hazel(means, pcov = pcov, gcov = gcov, weights = rep(1, 15))
print(index)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
