% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ge_acv.R
\name{ge_acv}
\alias{ge_acv}
\title{Adjusted Coefficient of Variation as yield stability index}
\usage{
ge_acv(.data, env, gen, resp, verbose = TRUE)
}
\arguments{
\item{.data}{The dataset containing the columns related to Environments,
Genotypes and response variable(s).}

\item{env}{The name of the column that contains the levels of the
environments.}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{resp}{The response variable(s). To analyze multiple variables in a
single procedure use, for example, \code{resp = c(var1, var2, var3)}.}

\item{verbose}{Logical argument. If \code{verbose = FALSE} the code will run
silently.}
}
\value{
An object of class \code{ge_acv}, which is a list containing the
results for each variable used in the argument \code{resp}. For each
variable, a tibble with the following columns is returned.
\itemize{
\item \strong{GEN} the genotype's code.
\item \strong{ACV} The adjusted coefficient of variation
\item \strong{ACV_R} The rank for the ACV value.
}
}
\description{
Performs a stability analysis based on the scale-adjusted coefficient of
variation (Doring and Reckling, 2018). For more details see
\code{\link{acv}()}
}
\examples{
\donttest{
library(metan)
out <- ge_acv(data_ge2, ENV, GEN, c(EH, PH, EL, CD, ED, NKE))
gmd(out)
}

}
\references{
Doring, T.F., and M. Reckling. 2018. Detecting global trends of
cereal yield stability by adjusting the coefficient of variation. Eur. J.
Agron. 99: 30-36. \doi{10.1016/j.eja.2018.06.007}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
