% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outdata.R
\name{outdata}
\alias{outdata}
\title{Construct \code{outdata} class}
\usage{
outdata(
  meta,
  population,
  observation,
  parameter,
  n,
  order,
  group,
  reference_group,
  ...
)
}
\arguments{
\item{meta}{A metadata object created by metalite.}

\item{population}{A character value of population term name.
The term name is used as key to link information.}

\item{observation}{A character value of observation term name.
The term name is used as key to link information.}

\item{parameter}{A character value of parameter term name.
The term name is used as key to link information.}

\item{n}{A data frame for number of subjects in each criteria.}

\item{order}{A numeric vector of row display order.}

\item{group}{A character vector of group variable names in an ADaM dataset.}

\item{reference_group}{A numeric value to indicate reference group
in levels of group.}

\item{...}{Additional variables to save to \code{outdata}.}
}
\value{
A list with class \code{outdata}.
Components of the list are either quosures or constants.
}
\description{
The \code{outdata} class defines a standard output format for
analysis and reporting.
}
\details{
The design is inspired by \code{ggplot2::aes()}.
}
\examples{
outdata(
  meta = meta_example(),
  population = "apat",
  observation = "wk12",
  parameter = "rel",
  n = data.frame(
    TRTA = c("Placebo", "Xanomeline Low Dose", "Xanomeline High Dose"),
    n = c(86, 84, 84)
  ),
  group = "TRTA",
  reference_group = 1,
  order = 1:3
)
}
