% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melt-package.R
\docType{package}
\name{melt-package}
\alias{melt}
\alias{melt-package}
\title{melt: Multiple Empirical Likelihood Tests}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Performs multiple empirical likelihood tests. It offers an easy-to-use interface and flexibility in specifying hypotheses and calibration methods, extending the framework to simultaneous inferences. The core computational routines are implemented using the 'Eigen' 'C++' library and 'RcppEigen' interface, with 'OpenMP' for parallel computation. Details of the testing procedures are provided in Kim, MacEachern, and Peruggia (2023) \doi{10.1080/10485252.2023.2206919}. A companion paper by Kim, MacEachern, and Peruggia (2024) \doi{10.18637/jss.v108.i05} is available for further information. This work was supported by the U.S. National Science Foundation under Grants No. SES-1921523 and DMS-2015552.
}
\references{
Kim E, MacEachern SN, Peruggia M (2023).
``Empirical likelihood for the analysis of experimental designs.''
\emph{Journal of Nonparametric Statistics}, \strong{35}(4), 709--732.
\doi{10.1080/10485252.2023.2206919}.

Kim E, MacEachern SN, Peruggia M (2024).
``melt: Multiple Empirical Likelihood Tests in R.''
\emph{Journal of Statistical Software}, \strong{108}(5), 1--33.
\doi{10.18637/jss.v108.i05}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/melt/}
  \item \url{https://github.com/ropensci/melt}
  \item Report bugs at \url{https://github.com/ropensci/melt/issues}
}

}
\author{
\strong{Maintainer}: Eunseop Kim \email{markean@pm.me} [copyright holder]

Other contributors:
\itemize{
  \item Steven MacEachern [contributor, thesis advisor]
  \item Mario Peruggia [contributor, thesis advisor]
  \item Pierre Chausse [reviewer]
  \item Alex Stringer [reviewer]
}

}
\keyword{internal}
