% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minESS.R
\name{minESS}
\alias{minESS}
\title{Minimum effective sample size required for stable estimation as described in Vats et al. (2015)}
\usage{
minESS(p, alpha = .05, eps = .05, ess = NULL)
}
\arguments{
\item{p}{dimension of the estimation problem.}

\item{alpha}{Confidence level.}

\item{eps}{Tolerance level. The eps value is ignored is \code{ess} is not \code{NULL}.}

\item{ess}{Estimated effective sample size. Usually the output value from \code{multiESS}.}
}
\value{
By default function returns the minimum effective sample required for a given eps
tolerance. If \code{ess} is specified, then the value returned is the \code{eps} corresponding to that \code{ess}.
}
\description{
The function calculates the minimum effective sample size required for a specified relative
tolerance level. This function can also calculate the relative precision in estimation for a given
estimated effective sample size.
}
\details{
The minimum effective samples required when estimating a vector of length \code{p}, with \eqn{100(
1-\alpha)\%} confidence and tolerance of \eqn{\epsilon} is \deqn{mESS \geq \frac{2^{2/p} \pi}{(p
\Gamma(p/2))^{2/p}} \frac{\chi^{2}_{1-\alpha,p}}{\epsilon^{2}}.}
The above equality can also be used to get \eqn{\epsilon} from an already obtained estimate of
mESS.
}
\examples{
minESS(p = 5)

}
\references{
Gong, L., and Flegal, J. M. A practical sequential stopping rule for high-dimensional Markov chain Monte Carlo. 
\emph{Journal of Computational and Graphical Statistics}, \bold{25},  684–-700.

Vats, D., Flegal, J. M., and, Jones, G. L Multivariate output analysis for Markov chain Monte Carlo, 
\emph{Biometrika}, \bold{106}, 321–-337.
}
\seealso{
\code{\link{multiESS}}, which calculates multivariate effective sample size using a
Markov chain and a function g.
\code{\link{ess}} which calculates univariate effective sample size using a Markov chain and a
function g.
}
