% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ByteCodeMutationUsingDoublesRandom}
\alias{ByteCodeMutationUsingDoublesRandom}
\title{Mutation operator for byte representation of double values}
\usage{
ByteCodeMutationUsingDoublesRandom(d, pmutation)
}
\arguments{
\item{d}{A vector of doubles}

\item{pmutation}{Probability of mutation}
}
\value{
Double vector of mutated solution
}
\description{
This function is a C++ wrapper for mutating byte representation of a given candidate solution. This mutation operator 
randomly changes a byte in the range of [0,255].
}
\examples{
set.seed(1246)
print(pi)
print(exp(1))
new.var <- ByteCodeMutationUsingDoublesRandom(c(pi, exp(1)), 0.10)
print(new.var)
}
\author{
Mehmet Hakan Satman - mhsatman@istanbul.edu.tr
}
\seealso{
ByteCodeMutation
}

