% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_indirect.R
\name{confint.indirect}
\alias{confint.indirect}
\title{Confidence Interval of
Indirect Effect or Conditional
Indirect Effect}
\usage{
\method{confint}{indirect}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{The output of
\code{\link[=indirect_effect]{indirect_effect()}} or
\code{\link[=cond_indirect]{cond_indirect()}}.}

\item{parm}{Ignored because the
stored object always has only one
parameter.}

\item{level}{The level of confidence,
default is .95, returning the 95\%
confidence interval.}

\item{...}{Additional arguments.
Ignored by the function.}
}
\value{
A numeric vector of
two elements, the limits of
the confidence interval.
}
\description{
Return the  bootstrap
confidence interval of the indirect
effect or conditional indirect effect
stored in the output of
\code{\link[=indirect_effect]{indirect_effect()}} or
\code{\link[=cond_indirect]{cond_indirect()}}.
}
\details{
It extracts and returns the
stored bootstrap confidence interval
if available.
}
\examples{

dat <- modmed_x1m3w4y1

# Indirect Effect

library(lavaan)
mod1 <-
"
m1 ~ x
m2 ~ m1
y  ~ m2 + x
"
fit <- sem(mod1, dat,
           meanstructure = TRUE, fixed.x = FALSE,
           se = "none", baseline = FALSE)
# R should be at least 2000 or 5000 in real research.
out1 <- indirect_effect(x = "x", y = "y",
                        m = c("m1", "m2"),
                        fit = fit,
                        boot_ci = TRUE, R = 45, seed = 54151,
                        parallel = FALSE,
                        progress = FALSE)
out1
confint(out1)


}
\seealso{
\code{\link[=indirect_effect]{indirect_effect()}} and
\code{\link[=cond_indirect]{cond_indirect()}}
}
