% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_2_and_3.R
\docType{data}
\name{data_med_mod_ab}
\alias{data_med_mod_ab}
\title{Sample Dataset: Simple
Mediation with Both Paths Moderated
(Two Moderators)}
\format{
A data frame with 100 rows
and 7 variables:
\describe{
\item{x}{Predictor. Numeric.}
\item{w1}{Moderator 1. Numeric.}
\item{w2}{Moderator 2. Numeric.}
\item{m}{Mediator. Numeric.}
\item{y}{Outcome variable. Numeric.}
\item{c1}{Control variable. Numeric.}
\item{c2}{Control variable. Numeric.}
}
}
\usage{
data_med_mod_ab
}
\description{
A simple mediation model
with a-path and b-path each moderated
by a moderator.
}
\examples{
library(lavaan)
data(data_med_mod_ab)
data_med_mod_ab$xw1 <-
 data_med_mod_ab$x *
 data_med_mod_ab$w1
data_med_mod_ab$mw2 <-
 data_med_mod_ab$m *
 data_med_mod_ab$w2
mod <-
"
m ~ a * x + w1 + d1 * xw1 + c1 + c2
y ~ b * m + x + w1 + w2 + d2 * mw2 + c1 + c2
w1 ~~ v_w1 * w1
w1 ~ m_w1 * 1
w2 ~~ v_w2 * w2
w2 ~ m_w2 * 1
ab := a * b
ab_lolo := (a + d1 * (m_w1 - sqrt(v_w1))) * (b + d2 * (m_w2 - sqrt(v_w2)))
ab_lohi := (a + d1 * (m_w1 - sqrt(v_w1))) * (b + d2 * (m_w2 + sqrt(v_w2)))
ab_hilo := (a + d1 * (m_w1 + sqrt(v_w1))) * (b + d2 * (m_w2 - sqrt(v_w2)))
ab_hihi := (a + d1 * (m_w1 + sqrt(v_w1))) * (b + d2 * (m_w2 + sqrt(v_w2)))
"
fit <- sem(mod, data_med_mod_ab,
           meanstructure = TRUE, fixed.x = FALSE)
parameterEstimates(fit)[c(1, 3, 6, 10, 41:45), ]
}
\keyword{datasets}
