% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_spectra.R
\name{remove_spectra}
\alias{remove_spectra}
\title{Remove (raw or processed) spectra}
\usage{
remove_spectra(spectra_list, to_remove)
}
\arguments{
\item{spectra_list}{A list of \link[MALDIquant:MassSpectrum-class]{MALDIquant::MassSpectrum} objects OR A list of processed spectra from \link{process_spectra}}

\item{to_remove}{The spectra to be removed. In the case of raw spectra: a logical vector same size of \code{spectra_list} or from \link{check_spectra} function. In the case of processed spectra: names of the spectra as formatted in \link{get_spectra_names} in the \code{sanitized_name} column.}
}
\value{
The same object as \code{spectra_list} minus the spectra in \code{to_remove}.
}
\description{
The \code{remove_spectra()} function is used to discard specific spectra from (1) raw spectra list by removing them, or (2) processed spectra by removing them from the spectra, peaks and metadata objects.
}
\examples{
# Get an example directory of six Bruker MALDI Biotyper spectra
directory_biotyper_spectra <- system.file(
  "toy-species-spectra",
  package = "maldipickr"
)
# Import only the first two spectra
spectra_list <- import_biotyper_spectra(directory_biotyper_spectra)[1:2]
# Introduce artificially an empty raw spectra
spectra_list <- c(spectra_list, MALDIquant::createMassSpectrum(0, 0))
# Empty spectra are detected by `check_spectra()`
#   and can be removed by `remove_spectra()`
spectra_list \%>\% 
  remove_spectra(to_remove = check_spectra(.))

# Get an example processed spectra
processed_path <- system.file(
    "three_processed_spectra_with_one_peakless.RDS",
    package = "maldipickr")
processed <- readRDS(processed_path) \%>\% list()

# Remove a specific spectra
remove_spectra(processed, "empty_H12")
}
