% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeParallel.R
\name{makeParallel}
\alias{makeParallel}
\title{Make Parallel Code From Serial}
\usage{
makeParallel(code, graph = inferGraph(code), run = FALSE,
  scheduler = schedule, ..., generator = generate, generatorArgs = list(),
  file = FALSE, prefix = "gen_", overWrite = FALSE)
}
\arguments{
\item{code}{file name or expression from \code{\link[base]{parse}}}

\item{graph}{object of class \linkS4class{DependGraph}}

\item{run}{logical, evaluate the code once to gather timings?}

\item{scheduler, }{function to produce a \linkS4class{Schedule}
from a \linkS4class{DependGraph}.}

\item{..., }{additional arguments to scheduler}

\item{generator}{function to produce \linkS4class{GeneratedCode} from a \linkS4class{Schedule}}

\item{generatorArgs}{list of named arguments to use with
\code{generator}}

\item{file}{character name of the file to write the generated script. 
If FALSE then don't write anything to disk.
If TRUE and code comes from a file then use \code{prefix} to make a new
name and write a script.}

\item{prefix}{character added to front of file name}

\item{overWrite}{logical write over existing generated file}
}
\value{
code object of class \linkS4class{GeneratedCode}
}
\description{
\code{makeParallel} is a high level function that performs all the steps
to generate parallel code, namely:
}
\details{
\enumerate{
 \item Infer the task graph
 \item Schedule the statements
 \item Generate parallel code
}

The arguments allow the user to control every aspect of this process.
For more details see \code{vignette("makeParallel-concepts")}.
}
\examples{
# Make an existing R script parallel
script <- system.file("examples/mp_example.R", package = "makeParallel")
makeParallel(script)

# Write generated code to a new file
newfile <- tempfile()
makeParallel(script, file = newfile)

# Clean up
unlink(newfile)

# Pass in code directly
d <- makeParallel(parse(text = "lapply(mtcars, mean)"))

# Now we can examine generated code
writeCode(d)

# Specify a different scheduler
pcode <- makeParallel(parse(text = "x <- 1:100
y <- rep(1, 100)
z <- x + y"), scheduler = scheduleTaskList)

# Some schedules have plotting methods
plot(schedule(pcode))
}
