% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lspkselect.R
\name{lspkselect}
\alias{lspkselect}
\alias{print.lspkselect}
\alias{summary.lspkselect}
\title{Tuning Parameter Selection Procedures for Partitioning-Based Regression Estimation and Inference}
\usage{
lspkselect(y, x, m = NULL, m.bc = NULL, deriv = NULL, method = "bs",
  ktype = "uni", kselect = "imse-dpi", proj = TRUE, bc = "bc3",
  vce = "hc2", subset = NULL)

\method{print}{lspkselect}(x, ...)

\method{summary}{lspkselect}(object, ...)
}
\arguments{
\item{y}{Outcome variable.}

\item{x}{Independent variable. A matrix or data frame.}

\item{m}{Order of basis used in the main regression. Default is \code{m=2}.}

\item{m.bc}{Order of basis used to estimate leading bias. Default is \code{m.bc=m+1}.}

\item{deriv}{Derivative order of the regression function to be estimated. A vector object of the same
length as \code{ncol(x)}. Default is \code{deriv=c(0,...,0)}.}

\item{method}{Type of basis used for expansion. Options are \code{"bs"} for B-splines,
\code{"wav"} for compact-supported wavelets (Cohen, Daubechies and Vial, 1993),
and \code{"pp"} for piecewise polynomials. Default is \code{method="bs"}.}

\item{ktype}{Knot placement. Options are \code{"uni"} for evenly spaced knots over the
support of \code{x} and \code{"qua"} for quantile-spaced knots. Default is \code{ktype="uni"}.}

\item{kselect}{Method for selecting the number of inner knots used by \code{lspkselect}. Options
are \code{"imse-rot"} for ROT implementation of IMSE-optimal number of knots,
\code{"imse-dpi"} for second generation of DPI implementation of IMSE-optimal number
of knots, and \code{"all"} for both. Default is \code{kselect="imse-dpi"}.}

\item{proj}{If true, projection of leading approximation error onto the lower-order approximating space
is included for bias correction (splines and piecewise polynomial only). Default is \code{proj=TRUE}.}

\item{bc}{Bias correction method. Options are \code{"bc1"} for higher-order bias correction,
\code{"bc2"} for least squares bias correction, and \code{"bc3"} for plug-in bias correction.
Default are \code{"bc3"} for splines and local polynomial partition series and \code{"bc2"}
for wavelets.}

\item{vce}{Procedure to compute the variance-covariance matrix estimator. Options are
\itemize{
\item \code{"hc0"} heteroskedasticity-robust plug-in residuals variance estimator
                 without weights.
\item \code{"hc1"} heteroskedasticity-robust plug-in residuals variance estimator
                 with hc1 weights.
\item \code{"hc2"} heteroskedasticity-robust plug-in residuals variance estimator
                 with hc2 weights. Default.
\item \code{"hc3"} heteroskedasticity-robust plug-in residuals variance estimator
                 with hc3 weights.
}}

\item{subset}{Optional rule specifying a subset of observations to be used.}

\item{...}{further arguments}

\item{object}{class \code{lspkselect} objects.}
}
\value{
\item{\code{ks}}{A matrix may contain \code{k.rot}(IMSE-optimal number of knots for
                        the main regression through ROT implementation), \code{k.bias.rot}
                        (IMSE-optimal number of knots for bias correction through ROT
                        implementation), \code{k.dpi}{IMSE-optimal number of knots for the
                        main regression through DPI implementation}, \code{k.bias.dpi}(IMSE-optimal
                        number of knots for bias correction through DPI implementation)}
       \item{\code{opt}}{A list containing options passed to the function.}
}
\description{
\code{lspkselect} implements IMSE-optimal data-driven procedures to select the number of partitioning knots for partitioning-based least squares regression estimators. Three series methods are supported: B-splines, compact supported wavelets, and piecewise polynomials (generalized regressograms).
            See \href{https://sites.google.com/site/nppackages/lspartition/Cattaneo-Farrell_2013_JoE.pdf?attredirects=0}{Cattaneo and Farrell (2013)} and \href{https://sites.google.com/site/nppackages/lspartition/Cattaneo-Farrell-Feng_2018_Partitioning.pdf?attredirects=0}{Cattaneo, Farrell and Feng (2018a)} for more technical details and further references.

            Companion command: \code{\link{lsprobust}} for partitioning-based least squares regression estimation and inference; \code{\link{lsprobust.plot}} for plotting results; \code{\link{lsplincom}} for multiple sample estimation and inference.

            A detailed introduction to this command is given in \href{https://sites.google.com/site/nppackages/lspartition/Cattaneo-Farrell-Feng_2018_lspartition.pdf?attredirects=0}{Cattaneo, Farrell and Feng (2018b)}.

            For more details, and related Stata and R packages useful for empirical analysis,
            visit \url{https://sites.google.com/site/nppackages/}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print}: \code{print} method for class "\code{lspkselect}".

\item \code{summary}: \code{summary} method for class "\code{lspkselect}".
}}

\examples{
x   <- data.frame(runif(500), runif(500))
y   <- sin(4*x[,1])+cos(x[,2])+rnorm(500)
est <- lspkselect(y, x)
summary(est)

}
\references{
Cattaneo, M. D., and M. H. Farrell (2013): \href{https://sites.google.com/site/nppackages/lspartition/Cattaneo-Farrell_2013_JoE.pdf?attredirects=0}{Optimal convergence rates, Bahadur representation, and asymptotic normality of partitioning estimators}. Journal of Econometrics 174(2): 127-143.

Cattaneo, M. D., M. H. Farrell, and Y. Feng (2018a): \href{https://sites.google.com/site/nppackages/lspartition/Cattaneo-Farrell-Feng_2018_Partitioning.pdf?attredirects=0}{Large Sample Properties of Partitioning-Based Series Estimators}. Working paper.

Cattaneo, M. D., M. H. Farrell, and Y. Feng (2018b): \href{https://sites.google.com/site/nppackages/lspartition/Cattaneo-Farrell-Feng_2018_lspartition.pdf?attredirects=0}{lspartition: Partitioning-Based Least Squares Regression}. Working paper.

Cohen, A., I. Daubechies, and P.Vial (1993): Wavelets on the Interval and Fast Wavelet Transforms. Applied and Computational Harmonic Analysis 1(1): 54-81.
}
\seealso{
\code{\link{lsprobust}}, \code{\link{lsprobust.plot}}, \code{\link{lsplincom}}
}
\author{
Matias D. Cattaneo, University of Michigan, Ann Arbor, MI. \email{cattaneo@umich.edu}.

Max H. Farrell, University of Chicago, Chicago, IL. \email{max.farrell@chicagobooth.edu}.

Yingjie Feng (maintainer), University of Michigan, Ann Arbor, MI. \email{yjfeng@umich.edu}.
}
