% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisher.R
\name{fisher}
\alias{fisher}
\title{Fisher information matrix for an object of class 'lmvar'}
\usage{
fisher(object, mu = TRUE, sigma = TRUE, ...)
}
\arguments{
\item{object}{Object of class 'lmvar'}

\item{mu}{Specifies whether or not the block-matrix for \eqn{\beta_\mu} is included in the returned matrix}

\item{sigma}{Specifies whether or not the block-matrix for \eqn{\beta_\sigma} is included in the returned matrix}

\item{...}{Additional arguments, not used in the current implementation}
}
\value{
An object of class 'matrix' containing the Fisher information matrix of \code{object}.
}
\description{
Fisher information matrix for
an object of class 'lmvar'.
}
\details{
The Fisher information matrix is calculated as minus \eqn{-E[H]/n} with \eqn{E[H]} the expected value of
the Hessian matrix \eqn{H} of the
log-likelihood and \eqn{n} the number of observations.

The matrix is calculated using the maximum-likelihood estimators of \eqn{\mu} and \eqn{\sigma}.

If \code{mu = TRUE} and \code{sigma = TRUE}, the full Fisher information matrix is returned.

If \code{mu = TRUE} and \code{sigma = FALSE}, only the left-upper block-matrix is returned, corresponding to the part of
the Fisher information matrix pertaining to \eqn{\beta_\mu}.

If \code{mu = FALSE} and \code{sigma = TRUE}, only the right-lower block-matrix is returned, corresponding to the part of
the Fisher information matrix pertaining to \eqn{\beta_\sigma}.
}
\examples{
# As example we use the dataset 'attenu' from the library 'datasets'. The dataset contains
# the response variable 'accel' and two explanatory variables 'mag'  and 'dist'.
library(datasets)

# Create the model matrix for the expected values
X = cbind(attenu$mag, attenu$dist)
colnames(X) = c("mag", "dist")

# Create the model matrix for the standard deviations.
X_s = cbind(attenu$mag, 1 / attenu$dist)
colnames(X_s) = c("mag", "dist_inv")

# Carry out the fit
fit = lmvar(attenu$accel, X, X_s)

# The complete Fisher information matrix is
fisher(fit)

# The left-upper block matrix relating to the expected values is
fisher(fit, sigma = FALSE)

# The right-lower block matrix relating to the variances is
fisher(fit, mu = FALSE)
}
\seealso{
\code{\link{vcov.lmvar}} calculates the covariance matrix for the maximum-likelihood estimators of
\eqn{\beta_\mu} and \eqn{\beta_\mu}

\code{\link{nobs.lmvar}} for the number of observations in an object of class 'lmvar'

\code{\link{coef.lmvar}} for the coefficients \eqn{\beta_\mu} and \eqn{\beta_\sigma}

\code{\link{fitted.lmvar}} for the expectation values \eqn{\mu} and standard deviations \eqn{\sigma}.

See the vignette "Math" (to be viewed with \code{vignette("Math", "lmvar")}) for details.
}
