% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_lme4.R, R/bootstrap_nlme.R,
%   R/generics.R
\name{bootstrap.merMod}
\alias{bootstrap.merMod}
\alias{bootstrap.lme}
\alias{bootstrap}
\title{Bootstrap Nested Linear Mixed-Effects Models}
\usage{
\method{bootstrap}{merMod}(model, .f, type, B, resample, reb_type, hccme, aux.dist)

\method{bootstrap}{lme}(model, .f, type, B, resample, reb_type, hccme, aux.dist)

bootstrap(
  model,
  .f,
  type,
  B,
  resample = NULL,
  reb_type = NULL,
  hccme = NULL,
  aux.dist = NULL
)
}
\arguments{
\item{model}{The model object you wish to bootstrap.}

\item{.f}{A function returning the statistic(s) of interest.}

\item{type}{A character string indicating the type of bootstrap that is being
requested. Possible values are \code{"parametric"}, \code{"residual"}, 
\code{"case"}, \code{"wild"}, \code{"wild"}, or \code{"reb"} 
(random effect block bootstrap).}

\item{B}{The number of bootstrap resamples.}

\item{resample}{A logical vector specifying whether each level of the model 
should be resampled in the cases bootstrap. The levels should be specified 
from the highest level (largest cluster) of the hierarchy to the lowest 
(observation-level); for example for students within a school, specify the 
school level first, then the student level.}

\item{reb_type}{Specification of what random effect block bootstrap version to
implement. Possible values are \code{0}, \code{1} or \code{2}.}

\item{hccme}{either \code{"hc2"} or \code{"hc3"}, indicating which 
heteroscedasticity consistent covariance matrix estimator to use.}

\item{aux.dist}{either \code{"f1"} or \code{"f2"} indicating which auxiliary 
distribution to draw the errors from}
}
\value{
The returned value is an object of class "lmeresamp". This is a list
with the following elements:

\itemize{
\item \code{observed}: the estimated values for the model parameters
\item \code{model}: the fitted model object
\item \code{.f}: the function call
\item \code{replicates}: a \eqn{B \times p} data frame of bootstrap values for each of the p model parameters,
\item \code{stats}: a tibble containing the \]code{observed}, \code{rep.mean} (bootstrap mean), 
\code{se} (bootstrap standard error), and \code{bias} values for each model parameter,
\item \code{B}: the number of bootstrap resamples performed
\item \code{data}: the data with which the model was fit
\item \code{seed}: a vector of randomly generated seeds that are used by the bootstrap
\item \code{type}: the type of bootstrap executed
\item \code{call}: the call to \code{bootstrap()} that the user
\item \code{message}: a list of length \code{B} giving any messages generated during refitting. An entry will be \code{NULL} if no message was generated.
\item \code{warning}: a list of length \code{B} giving any warnings generated during refitting. An entry will be \code{NULL} if no message was generated.
\item \code{error}: a list of length \code{B} giving any errors generated during refitting. An entry will be \code{NULL} if no message was generated.
}
}
\description{
Perform various bootstrap process for nested linear mixed effects (LMEs) models including:
parametric, residual, cases, wild, and REB bootstraps.
}
\details{
All of the below methods have been implemented for nested linear mixed-effects
models fit by \code{lmer} (i.e., an \code{lmerMod} object) and \code{lme} 
(i.e., an \code{lmerMod} object). Details of the bootstrap procedures can be found
in the help file for that specific function.
}
\examples{
library(lme4) 
vcmodA <- lmer(mathAge11 ~ mathAge8 + gender + class + (1 | school), data = jsp728)

## you can write your own function to return stats, or use something like 'fixef'
mySumm <- function(.) { 
  s <- getME(., "sigma")
    c(beta = getME(., "beta"), sigma = s, sig01 = unname(s * getME(., "theta"))) 
}

## running a parametric bootstrap 
set.seed(1234)
boo1 <- bootstrap(model = vcmodA, .f = mySumm, type = "parametric", B = 100)

\dontrun{
## running a cases bootstrap - only resampling the schools
boo2 <- bootstrap(model = vcmodA, .f = mySumm, type = "case", B = 100, resample = c(TRUE, FALSE))

## running a cases bootstrap - resampling the schools and students within the school
boo2 <- bootstrap(model = vcmodA, .f = mySumm, type = "case", B = 100, resample = c(TRUE, FALSE))

## running a semi-parametric bootstrap
boo3 <- bootstrap(model = vcmodA, .f = mySumm, type = "cgr", B = 100)

## running a residual bootstrap
boo4 <- bootstrap(model = vcmodA, .f = mySumm, type = "residual", B = 100)

## running an REB0 bootstrap
boo5 <- bootstrap(model = vcmodA, .f = mySumm, type = "reb", B = 100, reb_typ = 0)
}

## to print results in a formatted way
print(boo1)


}
\references{
Carpenter, J. R., Goldstein, H. and Rasbash, J. (2003) A novel bootstrap 
   procedure for assessing the relationship between class size and achievement. 
   \emph{Journal of the Royal Statistical Society. Series C (Applied Statistics)}, 
   \bold{52}, 431--443.
   
   Chambers, R. and Chandra, H. (2013) A random effect block bootstrap for 
   clustered data. \emph{Journal of Computational and Graphical Statistics}, 
   \bold{22}, 452--470.
   
   Morris, J. S. (2002) The BLUPs are not "best" when it comes to bootstrapping. 
   \emph{Statistics and Probability Letters}, \bold{56}, 425--430.
   
   Van der Leeden, R., Meijer, E. and Busing F. M. (2008) Resampling multilevel 
   models. In J. de Leeuw and E. Meijer, editors, \emph{Handbook of 
   Multilevel Analysis}, pages 401--433. New York: Springer.
   
   Bates, D., Maechler, M., Bolker, W., Walker, S. (2015).
   Fitting Linear Mixed-Effects Models Using lme4. \emph{Journal of
   Statistical Software}, \bold{67}, 1--48. doi:10.18637/jss.v067.i01.
   
   Modugno, L., & Giannerini, S. (2015). The Wild Bootstrap for 
   Multilevel Models. \emph{Communications in Statistics -- Theory and Methods}, 
   \bold{44}(22), 4812--4825.
}
\seealso{
\itemize{
  \item \code{\link{parametric_bootstrap}}, \code{\link{resid_bootstrap}},
     \code{\link{case_bootstrap}}, \code{\link{reb_bootstrap}}, 
     \code{\link{wild_bootstrap}} for more details on a specific bootstrap.
  \item \code{\link[lme4]{bootMer}} in the \pkg{lme4} package for an 
     implementation of (semi-)parameteric bootstrap for mixed models.
}
}
