% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information-matrices.R
\name{Fisher_info}
\alias{Fisher_info}
\title{Calculate expected, observed, or average Fisher information matrix}
\usage{
Fisher_info(mod, type = "expected")
}
\arguments{
\item{mod}{Fitted model of class lmeStruct or glsStruct.}

\item{type}{Type of information matrix. One of \code{"expected"} (the default),
\code{"observed"}, or \code{"average"}.}
}
\value{
Information matrix corresponding to variance component parameters of
  \code{mod}.
}
\description{
Calculates the expected, observed, or average Fisher information matrix
  from a fitted linear mixed effects model (lmeStruct object)
  or generalized least squares model (glsStruct object).
}
\examples{

library(nlme)
data(Bryant2016)
Bryant2016_RML <- lme(fixed = outcome ~ treatment,
                      random = ~ 1 | school/case,
                      correlation = corAR1(0, ~ session | school/case),
                      data = Bryant2016)
Fisher_info(Bryant2016_RML, type = "expected")
Fisher_info(Bryant2016_RML, type = "average")

}
