% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onehot.R
\name{onehot_with_decoder}
\alias{onehot_with_decoder}
\alias{onehot}
\alias{decode_onehot}
\alias{onehot_decoder}
\title{Convert vector to a onehot representation (binary class matrix)}
\usage{
onehot_with_decoder(y, order = NULL, named = TRUE)

onehot(y, order = NULL, named = TRUE)

decode_onehot(Y, classes = colnames(Y), n_classes = ncol(Y) \%||\%
  length(classes))

onehot_decoder(Y, classes = colnames(Y), n_classes = length(classes))
}
\arguments{
\item{y}{character, factor, or numeric vector}

\item{order}{\code{NULL}, \code{FALSE}, or a character vector. If \code{NULL} (the default),
then levels are sorted with \code{sort()}. If \code{FALSE}, then levels are taken in
order of their first appearance in \code{y}. If a character vector, then \code{order}
must contain all levels found in \code{y}.}

\item{named}{if the returned matrix should have column names}

\item{Y}{a matrix, as returned by \code{onehot()} or similar.}

\item{classes}{A character vector of class names in the order corresponding
to \code{Y}'s onehot encoding. Typically, \code{colnames(Y)}. if \code{NULL}, then the
decoder returns the column number.}

\item{n_classes}{The total number of classes expected in \code{Y}. Used for input
checking in the returned decoder, also, to reconstruct the correct
dimensions if the passed in \code{Y} is missing \code{dim()} attributes.}
}
\value{
A binary class matrix
}
\description{
Convert vector to a onehot representation (binary class matrix)
}
\examples{
if(require(zeallot)) {
  y <- letters[1:4]
  c(Y, decode) \%<-\% onehot_with_decoder(y)
  Y
  decode(Y)
  identical(y, decode(Y))
  decode(Y[2,,drop = TRUE])
  decode(Y[2,,drop = FALSE])
  decode(Y[2:3,])

  rm(Y, decode)
}

# more peicemeal functions
Y <- onehot(y)
decode_onehot(Y)

# if you need to decode a matrix that lost colnames,
# make your own decoder that remembers classes
my_decode <- onehot_decoder(Y)
colnames(Y) <- NULL
my_decode(Y)
decode_onehot(Y)

# factor and numeric vectors also accepted
onehot(factor(letters[1:4]))
onehot(4:8)

}
\seealso{
\link[keras:to_categorical]{keras::to_categorical}
}
