% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shuffle.R
\name{shuffle_rows}
\alias{shuffle_rows}
\title{Shuffle along the first dimension multiple arrays in sync}
\usage{
shuffle_rows(..., in_sync = TRUE)
}
\arguments{
\item{...}{arrays of various dimensions (vectors and data.frames OK too)}

\item{in_sync}{if the objects should be shuffled in sync (i.e., row order is
the same in all returned objects)}
}
\value{
A list of objects passed on to \code{...}
}
\description{
Shuffle along the first dimension multiple arrays in sync
}
\examples{
x <- 1:3
y <- matrix(1:9, ncol = 3)
z <- array(1:27, c(3,3,3))

if(require(zeallot)) {
  c(xs, ys, zs) \%<-\% shuffle_rows(x, y, z)

  l <- lapply(seq_along_rows(y), function(r) {
    list(x = x[r], y = y[r,], z = z[r,,])
  })

  ls <- lapply(seq_along_rows(y), function(r) {
    list(x = xs[r], y = ys[r,], z = zs[r,,])
  })

  stopifnot(
    length(unique(c(l, ls))) == length(l))
}
}
