% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnecessary_lambda_linter.R
\name{unnecessary_lambda_linter}
\alias{unnecessary_lambda_linter}
\title{Block usage of anonymous functions in iteration functions when unnecessary}
\usage{
unnecessary_lambda_linter()
}
\description{
Using an anonymous function in, e.g., \code{\link[=lapply]{lapply()}} is not always necessary,
e.g. \code{lapply(DF, sum)} is the same as \code{lapply(DF, function(x) sum(x))} and
the former is more readable.
}
\examples{
# will produce lints
lint(
  text = "lapply(list(1:3, 2:4), function(xi) sum(xi))",
  linters = unnecessary_lambda_linter()
)

# okay
lint(
  text = "lapply(list(1:3, 2:4), sum)",
  linters = unnecessary_lambda_linter()
)

lint(
  text = 'lapply(x, function(xi) grep("ptn", xi))',
  linters = unnecessary_lambda_linter()
)

lint(
  text = "lapply(x, function(xi) data.frame(col = xi))",
  linters = unnecessary_lambda_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}
}
