% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implicit_assignment_linter.R
\name{implicit_assignment_linter}
\alias{implicit_assignment_linter}
\title{Avoid implicit assignment in function calls}
\usage{
implicit_assignment_linter(
  except = c("bquote", "expression", "expr", "quo", "quos", "quote")
)
}
\arguments{
\item{except}{A character vector of functions to be excluded from linting.}
}
\description{
Assigning inside function calls makes the code difficult to read, and should
be avoided, except for functions that capture side-effects (e.g. \code{\link[=capture.output]{capture.output()}}).
}
\examples{
# will produce lints
lint(
  text = "if (x <- 1L) TRUE",
  linters = implicit_assignment_linter()
)

lint(
  text = "mean(x <- 1:4)",
  linters = implicit_assignment_linter()
)

# okay
writeLines("x <- 1L\nif (x) TRUE")
lint(
  text = "x <- 1L\nif (x) TRUE",
  linters = implicit_assignment_linter()
)

writeLines("x <- 1:4\nmean(x)")
lint(
  text = "x <- 1:4\nmean(x)",
  linters = implicit_assignment_linter()
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://style.tidyverse.org/syntax.html#assignment}
}
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=configurable_linters]{configurable}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
