% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkspotterGraph.R
\name{linkspotterGraph}
\alias{linkspotterGraph}
\title{Linspotter graph runner}
\usage{
linkspotterGraph(corDF, variablesClustering = NULL, minCor = 0.3,
  corMethod = colnames(corDF)[-c(1:3,
  ncol(corDF))][length(colnames(corDF)[-c(1:3, ncol(corDF))])],
  smoothEdges = T, dynamicNodes = F, colorEdgesByCorDirection = F)
}
\arguments{
\item{corDF}{a specific dataframe containing correlations values resulting from the function multiBivariateCorrelation()}

\item{variablesClustering}{a specific dataframe containing the output of the variable clustering resulting from the function clusterVariables()}

\item{minCor}{a double between 0 and 1. It is the minimal correlation absolute value to consider for the first graph plot.}

\item{corMethod}{a string. One of "pearson","spearman","kendall","mic", "distCor" or "MaxNMI". It is the correlation coefficient to consider for the first graph plot.}

\item{smoothEdges}{a boolean. TRUE to let the edges be smooth.}

\item{dynamicNodes}{a boolean. TRUE to let the graph re-organize itself after any movement.}

\item{colorEdgesByCorDirection}{a boolean. TRUE to get the edges colored according to the correlation direction (positive-> blue, negative->red or NA->grey).}
}
\value{
a visNetwork object corresponding to a dynamic graph for the correlation matrix visualization.
}
\description{
Run the linkSpotter graph
}
\examples{
# calculate a correlation dataframe
data(iris)
corDF=multiBivariateCorrelation(dataset = iris)
corMatrix=corCouplesToMatrix(x1_x2_val = corDF[,c('X1','X2',"spearman")])
corGroups=clusterVariables(corMatrix = corMatrix, nbCluster = 3)
# launch the graph
linkspotterGraph(corDF=corDF, variablesClustering=corGroups, minCor=0.3,
corMethod='spearman', colorEdgesByCorDirection=TRUE)

}
