% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet.R
\name{process_sf_data}
\alias{process_sf_data}
\title{Process SF Data for Leaflet Integration}
\usage{
process_sf_data(data, lng_col = "longitude", lat_col = "latitude")
}
\arguments{
\item{data}{Data frame or sf object. If sf object, coordinates will be extracted.}

\item{lng_col}{Character string. Name for the longitude column (default: "longitude")}

\item{lat_col}{Character string. Name for the latitude column (default: "latitude")}
}
\value{
Data frame with explicit lng/lat columns, ready for leaflet integration
}
\description{
\code{process_sf_data} is a helper function to extract coordinates from an sf object or ensure lng/lat columns exist in a data frame.
}
\details{
This function handles three scenarios:
\itemize{
\item SF objects: Extracts coordinates using sf::st_coordinates() and creates lng/lat columns
\item Regular data frames with existing lng/lat columns: Returns unchanged
\item Regular data frames without lng/lat columns: Issues warning and returns unchanged
}

For sf objects, the function:
\itemize{
\item Extracts point coordinates from the geometry column
\item Adds coordinates as new columns with the specified names
\item Preserves the original geometry column for advanced spatial operations
\item Returns an sf object with both geometry and coordinate columns
}
}
\examples{
if (requireNamespace("sf", quietly = TRUE)) {
  # Create a sample sf object
  sf_data <- sf::st_as_sf(
    data.frame(
      id = 1:2,
      name = c("A", "B"),
      geom = c("POINT(-111.9 40.7)", "POINT(-111.8 40.6)")
    ),
    wkt = "geom",
    crs = 4326
  )

  # Process the sf object
  processed_data <- process_sf_data(sf_data)
  print(processed_data)
}

}
\keyword{internal}
