% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_hull.R
\name{st_hull}
\alias{st_hull}
\alias{st_concave_hull}
\alias{st_convex_hull.LAS}
\alias{concaveman}
\title{Concave and convex hulls for LAS objects}
\usage{
st_concave_hull(x, method = "concaveman", ...)

\method{st_convex_hull}{LAS}(x)

concaveman(x, y = NULL, concavity = 2, length_threshold = 0)
}
\arguments{
\item{x, y}{An object of class LAS or XY coordinates of points in case of \code{concaveman}. This can be
specified as two vectors x and y, a 2-column matrix x, a list with two components, etc.}

\item{method}{string. currently supports "concaveman".}

\item{...}{Propagate to the method.}

\item{concavity}{numeric a relative measure of concavity. 1 results in a relatively detailed shape,
Infinity results in a convex hull. You can use values lower than 1, but they can produce pretty crazy
shapes.}

\item{length_threshold}{numeric. When a segment length is below this threshold, it stops being
considered for further detailed processing. Higher values result in simpler shapes.}
}
\value{
A \code{sfc_POLYGON} from \code{sf} or a \code{data.frame} in the case of \code{concaveman}
}
\description{
Concave and convex hulls for LAS objects. \code{st_convex_hull} extends \code{sf::st_convex_hull} for LAS
objects. Both functions return a \code{sfc_POLYGON}. \code{concaveman} is very a fast 2D concave hull algorithm
for a set of points.
}
\details{
The concaveman algorithm is based on ideas from Park and Oh (2012). A first implementation in
JavaScript was proposed by Vladimir Agafonkin in \href{https://github.com/mapbox/concaveman}{mapbox}.
This implementation dramatically improved performance over the one stated in the paper
using a spatial index. The algorithm was then ported to R by Joël Gombin in the R package
\href{https://github.com/joelgombin/concaveman}{concaveman} that runs the JavaScript
implementation proposed by Vladimir Agafonkin. Later, a C++ version of Vladimir Agafonkin's
JavaScript implementation was proposed by Stanislaw Adaszewski in
\href{https://github.com/sadaszewski/concaveman-cpp}{concaveman-cpp}. This concaveman
function uses Stanislaw Adaszewski's C++ code making the concaveman algorithm an
order of magnitude (up to 50 times) faster than the Javascript version.
}
\examples{
x <- runif(35)
y <- runif(35)
hull <- concaveman(x,y)
plot(x,y, asp = 1)
lines(hull, lwd = 3, col = "red")

LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las = readLAS(LASfile, filter = "-drop_z_below 1")
hull = st_concave_hull(las, length_threshold = 10)
plot(hull)
}
\references{
Park, J.-S & Oh, S.-J. (2013). A New Concave Hull Algorithm and Concaveness Measure
for n-dimensional Datasets. Journal of Information Science and Engineering. 29. 379-392.
}
