% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/private_funs.R
\name{wrap_long}
\alias{wrap_long}
\title{Truncate and wrap long text for console printing}
\usage{
wrap_long(..., trim = 200, width = 80, indent = 4, exdent = indent,
  prefix = "\\n", initial = "")
}
\arguments{
\item{...}{(Vectors) Vectors that will be joined together.}

\item{trim}{(Int) The maximum length that \code{char} will be truncated to.}

\item{width}{(Int) The target maximum column number to wrap the text at.}

\item{indent}{(Int) Indent the first line by this many spaces.}

\item{exdent}{(Int) Indent subsequent lines by this many spaces.}

\item{prefix}{(Char) Begin every line with this string.}

\item{initial}{(Char) Begin the first line with this string.}
}
\value{
A character vector.
}
\description{
Truncate and wrap long text for console printing
}
\examples{
\dontrun{
wrap_long("This is a pretty long line that will need to be wrapped to 30 chars.",
          trim = 50, width = 30) -> wrapped_text

cat(wrapped_text)

#>    This is a pretty long 
#>    line that will need to 
#>    be wr[...]
}

}
