% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leidenbase.R
\name{leiden_find_partition}
\alias{leiden_find_partition}
\title{Leiden find partition community detection function}
\usage{
leiden_find_partition(
  igraph,
  partition_type = c("CPMVertexPartition", "ModularityVertexPartition",
    "RBConfigurationVertexPartition", "RBERVertexPartition",
    "SignificanceVertexPartition", "SurpriseVertexPartition"),
  initial_membership = NULL,
  edge_weights = NULL,
  node_sizes = NULL,
  seed = NULL,
  resolution_parameter = 0.1,
  num_iter = 2,
  verbose = FALSE
)
}
\arguments{
\item{igraph}{R igraph graph.}

\item{partition_type}{String partition type name. Default is
CPMVertexParition.}

\item{initial_membership}{Numeric vector of initial membership
assignments of nodes. These are 1-based indices. Default is one
community per node.}

\item{edge_weights}{Numeric vector of edge weights. Default is 1.0 for
all edges.}

\item{node_sizes}{Numeric vector of node sizes. Default is 1 for all
nodes.}

\item{seed}{Numeric random number generator seed. The seed value must be
either NULL for random seed values or greater than 0 for a fixed seed
value. Default is NULL.}

\item{resolution_parameter}{Numeric resolution parameter. The value
must be greater than 0.0. Default is 0.1. The resolution_parameter is
ignored for the partition_types ModularityVertexPartition,
SignificanceVertexPartition, and SurpriseVertexPartition.}

\item{num_iter}{Numeric number of iterations. Default is 2.}

\item{verbose}{A logic flag to determine whether or not we should print
run diagnostics.}
}
\value{
A named list consisting of a numeric vector of the node
 community memberships (1-based indices), a numeric quality value,
 a numeric modularity, a numeric significance, a numeric vector of
 edge weights within each community, a numeric vector of edge weights
 from each community, a numeric vector of edge weights to each
 community, and total edge weight in the graph.
}
\description{
R to C wrapper that runs the basic Leiden community detection algorithm,
which is similar to the find_partition() function in the python Leidenalg distribution.
}
\details{
The Leiden algorithm is described in
 From Louvain to Leiden: guaranteeing well-connected communities.
 V. A. Traag and L. Waltman and N. J. van Eck
 Scientific Reports, 9(1) (2019)
 DOI: 10.1038/s41598-019-41695-z.

Significance is described in
 Significant Scales in Community Structure
 V. A. Traag, G. Krings, and P. Van Dooren
 Scientific Reports, 3(1) (2013)
 DOI: 10.1038/srep02930

Notes excerpted from leidenalg/src/VertexPartition.py
\itemize{
  \item \emph{ CPMVertexPartition }
        Implements Constant Potts Model. 
        This quality function uses a linear resolution parameter and
        is well-defined for both positive and negative edge weights.
  \item \emph{ ModularityVertexPartition }
        Implements modularity. 
        This quality function is well-defined only for positive edge weights.
  \item\emph{  RBConfigurationVertexPartition }
        Implements Reichardt and Bornholdt’s Potts model with a configuration null model. 
        This quality function uses a linear resolution parameter and is well-defined only
        for positive edge weights.
  \item \emph{ RBERVertexPartition }
        Implements Reichardt and Bornholdt’s Potts model with an Erdos-Renyi null model.
        This quality function uses a linear resolution parameter and is well-defined only
        for positive edge weights.
  \item \emph{ SignificanceVertexPartition }
        Implements Significance. 
        This quality function is well-defined only for unweighted graphs.
  \item \emph{ SurpriseVertexPartition }
        Implements (asymptotic) Surprise.
        This quality function is well-defined only for positive edge weights.
}
}
\examples{
  library(igraph)
  fpath <- system.file( 'testdata', 'igraph_n1500_edgelist.txt.gz', package = 'leidenbase' )
  zfp <- gzfile(fpath)
  igraph <- read_graph( file = zfp, format='edgelist', n=1500 )
  res <- leiden_find_partition(igraph=igraph,
                               partition_type='CPMVertexPartition',
                               resolution_parameter=1e-5)

}
\references{
V. A. Traag, L. Waltman, N. J. van Eck (2019). From Louvain
 to Leiden: guaranteeing well-connected communities.
 Scientific Reports, 9(1).
 DOI: 10.1038/s41598-019-41695-z

Significant Scales in Community Structure
 V. A. Traag, G. Krings, and P. Van Dooren
 Scientific Reports, 3(1) (2013)
 DOI: 10.1038/srep02930
}
