% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmm.latent.R
\name{euclidean2-ergmTerm}
\alias{euclidean2-ergmTerm}
\alias{InitErgmTerm.euclidean2}
\title{Squared euclidean distance latent space, with optional clustering}
\usage{
# binary: euclidean(d, G=0, var.mul=1/8, var=NULL, var.df.mul=1, var.df=NULL,
#             mean.var.mul=1, mean.var=NULL, pK.mul=1, pK=NULL)

# valued: euclidean(d, G=0, var.mul=1/8, var=NULL, var.df.mul=1, var.df=NULL,
#             mean.var.mul=1, mean.var=NULL, pK.mul=1, pK=NULL)
}
\arguments{
\item{d}{The dimension of the latent space.}

\item{G}{The number of groups (0 for no clustering).}

\item{var.mul}{In the absence of \code{var}, this argument will be
used as a scaling factor for a function of average cluster size
and latent space dimension to set \code{var}. To set it in the
\code{prior} argument to \code{\link{ergmm}}, use
\code{Z.var.mul}.}

\item{var}{If given, the scale parameter for the
scale-inverse-chi-squared prior distribution of the
within-cluster variance. To set it in the \code{prior} argument
to \code{\link{ergmm}}, use \code{Z.var}.}

\item{var.df.mul}{In the absence of \code{var.df}, this argument is
the multiplier for the square root of average cluster size, which
serves in place of \code{var.df}. To set it in the \code{prior}
argument to \code{\link{ergmm}}, use \code{Z.var.df.mul}.}

\item{var.df}{The degrees of freedom parameter for the
scale-inverse-chi-squared prior distribution of the
within-cluster variance. To set it in the \code{prior} argument
to \code{\link{ergmm}}, use \code{Z.var.df}.}

\item{mean.var.mul}{In the absence of \code{mean.var}, the
multiplier for a function of number of vertices and latent space
dimension to set \code{mean.var}. To set it in the \code{prior}
argument to \code{\link{ergmm}}, use \code{Z.mean.var.mul}.}

\item{mean.var}{The variance of the spherical Gaussian prior
distribution of the cluster means. To set it in the \code{prior}
argument to \code{\link{ergmm}}, use \code{Z.mean.var}.}

\item{pK.mul}{In the absence of \code{pK}, this argument is the
multiplier for the square root of the average cluster size, which
is used as \code{pK}. To set it in the \code{prior} argument to
\code{\link{ergmm}}, use \code{Z.pK}.}

\item{pK}{The parameter of the Dirichilet prior distribution of
cluster assignment probabilities. To set it in the \code{prior}
argument to \code{\link{ergmm}}, use \code{Z.pK}.}
}
\description{
Adds a term to the model equal to the negative
Eucledean distance \eqn{-||Z_i-Z_j||^2}{-dist(Z[i],Z[j])^2}, where
\eqn{Z_i}{Z[i]} and \eqn{Z_j}{Z[j]} are the positions of their
respective actors in an unobserved social space. These positions
may optionally have a finite spherical Gaussian mixture
clustering structure. This term was previously called
\code{latent}.

\strong{Important:} This term works in \CRANpkg{latentnet}'s \code{\link[=ergmm]{ergmm()}} only. Using it in \code{\link[=ergm]{ergm()}} will result in an error.
}
\details{
The following parameters are associated with this term:
\describe{
\item{\code{Z}}{ Numeric matrix with rows being latent space
positions.}
\item{\code{Z.K} (when \eqn{\code{G}>0})}{ Integer vector of
cluster assignments. }
\item{\code{Z.mean} (when \eqn{\code{G}>0})}{ Numeric matrix
with rows being cluster means. }
\item{\code{Z.var} (when \eqn{\code{G}>0})}{ Depending on the
model, either a numeric vector with within-cluster variances
or a numeric scalar with the overal latent space variance. }
\item{\code{Z.pK} (when \eqn{\code{G}>0})}{ Numeric vector of
probabilities of a vertex being in a particular cluster.}
}
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "euclidean2", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{latent}
\concept{undirected}
