% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvh.R
\name{obj2kvh}
\alias{obj2kvh}
\title{Writing/adding an R object to kvh file.}
\usage{
obj2kvh(obj, objname, conct = stdout(), indent = 0)
}
\arguments{
\item{obj}{an R object}

\item{objname}{character object name to write in kvh file}

\item{conct}{connection opened for writing}

\item{indent}{is tab offset for object name}
}
\value{
None
}
\description{
Formats an object before writing it in kvh file.
}
\details{
Scalar, vector, matrix and list are pre-processed.
Other objects are written as an output string of toString() function
To add a content to existent file use "a" as open mode
\code{fcn=file("m.kvh", "a")}
\code{obj2kvh()} can be used along the code advancing in the calculations.
Writing in a subfield of an already started key requires use of
appropriate indent value. The file is started with indent=0 and
every sub-field increments the indent by 1.
}
\examples{
m=matrix(1:6,2,3);
fcn=file("m.kvh", "w");
obj2kvh(m, "m", fcn);
close(fcn);

}
