% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnalysisFunctions.R
\name{draw_aois}
\alias{draw_aois}
\title{Draw one or more areas of interest, AOIs, on a stimulus image and save to the R prompt.
The input is the path to a 2D image. Supported file formats: JPEG, BMP, PNG.
The function returns a data frame with all saved AOIs. By default, AOIs are drawn in a
coordinate system where y is 0 in the lower extreme of the image, e.g., an ascending y axis. Tobii eye trackers use a coordinate system with a descending
y-axis, e.g., x and y are 0 in the upper left corner of the image. Make sure that your AOIS match the coordinate system of your eye tracker output.
By setting the parameter reverse.y.axis to TRUE, the saved AOIs will be reformatted to fit a coordinate system with a descending y-axis.
All AOIS have the variables x0, x1, y0 and y1. x0 is the minimum x value, y0 the minimum y value. x1 the maximum x value. y1 the maximum y value}
\usage{
draw_aois(image.path, reverse.y.axis = FALSE)
}
\arguments{
\item{image.path}{path to a valid image file with the suffix .jpeg, .jpg, .png or .bmp}

\item{reverse.y.axis}{If TRUE, save AOIs positioned on a reverse Y-axis where y is 0 in the upper end of the image. Note that AOIs will be converted to fit a reversed Y axis
before printed in the R prompt and saved, but will be shown in the original coordinate system when plotted inside the function.}
}
\value{
data frame with type and coordinates of drawn AOIs
}
\description{
Draw one or more areas of interest, AOIs, on a stimulus image and save to the R prompt.
The input is the path to a 2D image. Supported file formats: JPEG, BMP, PNG.
The function returns a data frame with all saved AOIs. By default, AOIs are drawn in a
coordinate system where y is 0 in the lower extreme of the image, e.g., an ascending y axis. Tobii eye trackers use a coordinate system with a descending
y-axis, e.g., x and y are 0 in the upper left corner of the image. Make sure that your AOIS match the coordinate system of your eye tracker output.
By setting the parameter reverse.y.axis to TRUE, the saved AOIs will be reformatted to fit a coordinate system with a descending y-axis.
All AOIS have the variables x0, x1, y0 and y1. x0 is the minimum x value, y0 the minimum y value. x1 the maximum x value. y1 the maximum y value
}
