% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-training.R
\name{predict.keras.src.models.model.Model}
\alias{predict.keras.src.models.model.Model}
\title{Generates output predictions for the input samples.}
\usage{
\method{predict}{keras.src.models.model.Model}(
  object,
  x,
  ...,
  batch_size = NULL,
  verbose = getOption("keras.verbose", default = "auto"),
  steps = NULL,
  callbacks = NULL
)
}
\arguments{
\item{object}{Keras model object}

\item{x}{Input samples. It could be:
\itemize{
\item A array (or array-like), or a list of arrays
(in case the model has multiple inputs).
\item A tensor, or a list of tensors
(in case the model has multiple inputs).
\item A TF Dataset.
}}

\item{...}{For forward/backward compatability.}

\item{batch_size}{Integer or \code{NULL}.
Number of samples per batch.
If unspecified, \code{batch_size} will default to \code{32}.
Do not specify the \code{batch_size} if your data is in the
form of a TF Dataset or a generator
(since they generate batches).}

\item{verbose}{\code{"auto"}, \code{0}, \code{1}, or \code{2}. Verbosity mode.
\code{0} = silent, \code{1} = progress bar, \code{2} = one line per epoch.
\code{"auto"} becomes 1 for most cases,
\code{2} if in a knitr render or running on a distributed training server.
Note that the progress bar is not
particularly useful when logged to a file,
so \code{verbose=2} is recommended when not running interactively
(e.g., in a production environment). Defaults to \code{"auto"}.}

\item{steps}{Total number of steps (batches of samples)
before declaring the prediction round finished.
Ignored with the default value of \code{NULL}.
If \code{x} is a TF Dataset and \code{steps} is \code{NULL},
\code{predict()} will run until the input dataset is exhausted.}

\item{callbacks}{List of \code{Callback} instances.
List of callbacks to apply during prediction.}
}
\value{
R array(s) of predictions.
}
\description{
Generates output predictions for the input samples.
}
\details{
Computation is done in batches. This method is designed for batch
processing of large numbers of inputs. It is not intended for use inside
of loops that iterate over your data and process small numbers of inputs
at a time.

For small numbers of inputs that fit in one batch,
directly call the model \code{model$call} for faster execution, e.g.,
\code{model(x)}, or \code{model(x, training = FALSE)} if you have layers such as
\code{BatchNormalization} that behave differently during
inference.
}
\section{Note}{
See \href{https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call}{this FAQ entry}
for more details about the difference between \code{Model} methods
\code{predict()} and \code{call()}.
}

\seealso{
\itemize{
\item \url{https://keras.io/api/models/model_training_apis#predict-method}
}

Other model training: \cr
\code{\link{compile.keras.src.models.model.Model}()} \cr
\code{\link{evaluate.keras.src.models.model.Model}()} \cr
\code{\link{predict_on_batch}()} \cr
\code{\link{test_on_batch}()} \cr
\code{\link{train_on_batch}()} \cr
}
\concept{model training}
