% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_r2_score}
\alias{metric_r2_score}
\title{Computes R2 score.}
\usage{
metric_r2_score(
  ...,
  class_aggregation = "uniform_average",
  num_regressors = 0L,
  name = "r2_score",
  dtype = NULL
)
}
\arguments{
\item{...}{For forward/backward compatability.}

\item{class_aggregation}{Specifies how to aggregate scores corresponding to
different output classes (or target dimensions),
i.e. different dimensions on the last axis of the predictions.
Equivalent to \code{multioutput} argument in Scikit-Learn.
Should be one of
\code{NULL} (no aggregation), \code{"uniform_average"},
\code{"variance_weighted_average"}.}

\item{num_regressors}{Number of independent regressors used
("Adjusted R2" score). 0 is the standard R2 score.
Defaults to \code{0}.}

\item{name}{Optional. string name of the metric instance.}

\item{dtype}{Optional. data type of the metric result.}
}
\value{
a \code{Metric} instance is returned. The \code{Metric} instance can be passed
directly to \code{compile(metrics = )}, or used as a standalone object. See
\code{?Metric} for example usage.
}
\description{
Formula:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{sum_squares_residuals <- sum((y_true - y_pred) ** 2)
sum_squares <- sum((y_true - mean(y_true)) ** 2)
R2 <- 1 - sum_squares_residuals / sum_squares
}\if{html}{\out{</div>}}

This is also called the
\href{https://en.wikipedia.org/wiki/Coefficient_of_determination}{coefficient of determination}.

It indicates how close the fitted regression line
is to ground-truth data.
\itemize{
\item The highest score possible is 1.0. It indicates that the predictors
perfectly accounts for variation in the target.
\item A score of 0.0 indicates that the predictors do not
account for variation in the target.
\item It can also be negative if the model is worse than random.
}

This metric can also compute the "Adjusted R2" score.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{y_true <- rbind(1, 4, 3)
y_pred <- rbind(2, 4, 4)
metric <- metric_r2_score()
metric$update_state(y_true, y_pred)
metric$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(0.57142854, shape=(), dtype=float32)

}\if{html}{\out{</div>}}
}

\seealso{
Other regression metrics: \cr
\code{\link{metric_cosine_similarity}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr

Other metrics: \cr
\code{\link{Metric}()} \cr
\code{\link{custom_metric}()} \cr
\code{\link{metric_auc}()} \cr
\code{\link{metric_binary_accuracy}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_binary_iou}()} \cr
\code{\link{metric_categorical_accuracy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_cosine_similarity}()} \cr
\code{\link{metric_f1_score}()} \cr
\code{\link{metric_false_negatives}()} \cr
\code{\link{metric_false_positives}()} \cr
\code{\link{metric_fbeta_score}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_iou}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_iou}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_mean_wrapper}()} \cr
\code{\link{metric_one_hot_iou}()} \cr
\code{\link{metric_one_hot_mean_iou}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_precision}()} \cr
\code{\link{metric_precision_at_recall}()} \cr
\code{\link{metric_recall}()} \cr
\code{\link{metric_recall_at_precision}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr
\code{\link{metric_sensitivity_at_specificity}()} \cr
\code{\link{metric_sparse_categorical_accuracy}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_sparse_top_k_categorical_accuracy}()} \cr
\code{\link{metric_specificity_at_sensitivity}()} \cr
\code{\link{metric_squared_hinge}()} \cr
\code{\link{metric_sum}()} \cr
\code{\link{metric_top_k_categorical_accuracy}()} \cr
\code{\link{metric_true_negatives}()} \cr
\code{\link{metric_true_positives}()} \cr
}
\concept{metrics}
\concept{regression metrics}
