% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jagshelper1.R
\name{caterpillar}
\alias{caterpillar}
\title{Caterpillar plot}
\usage{
caterpillar(
  df,
  p = NULL,
  x = NA,
  row = NULL,
  column = NULL,
  median = TRUE,
  mean = FALSE,
  ci = c(0.5, 0.95),
  lwd = 1,
  col = 4,
  add = FALSE,
  xlab = "",
  ylab = "",
  main = NULL,
  ylim = NULL,
  xax = NA,
  transform = c("none", "exp", "expit"),
  medlwd = lwd,
  medwd = 1,
  ...
)
}
\arguments{
\item{df}{Output object returned from \code{jagsUI::jags()}; or alternately,
two-dimensional \code{data.frame} or matrix in which parameter node element is
given by column and MCMC iteration is given by row.  A vector may also be used,
that expresses MCMC iterations of a single parameter node.}

\item{p}{Parameter name, if input to \code{df} is a \code{jagsUI} output object.}

\item{x}{Vector of X-coordinates for plotting.}

\item{row}{Row to subset, in the case of a 2-d matrix of parameter nodes in-model.}

\item{column}{Column to subset, in the case of a 2-d matrix of parameter nodes in-model.}

\item{median}{Whether to include medians}

\item{mean}{Whether to include means}

\item{ci}{Vector of intervals to overlay.  Defaults to 50 percent and 95 percent.}

\item{lwd}{Base line width for plotting.  Defaults to 1.}

\item{col}{Color for plotting}

\item{add}{Whether to add to existing plot}

\item{xlab}{X-axis label}

\item{ylab}{Y-axis label}

\item{main}{Plot title.  If the default (\code{NULL}) is accepted and argument \code{p} is used, \code{p} will be used for the title.}

\item{ylim}{Y-axis limits.  If the default (\code{NULL}) is accepted, the limits will be determined automatically.}

\item{xax}{Vector of possible x-axis tick labels.  Defaults to the \code{data.frame} column names.}

\item{transform}{Should the y-axis be (back)transformed?  Options are \code{"exp"},
indicating exponential, or \code{"expit"}, indicating inverse-logit. Defaults to
\code{"none"}, indicating no transformation.  Note: if \code{transform="exp"}is used, consider
adding additional plotting argument \code{log="y"}.}

\item{medlwd}{Line width of median line}

\item{medwd}{Relative width of median line.  Defaults to 1, perhaps smaller numbers will look better?}

\item{...}{additional plotting arguments}
}
\value{
\code{NULL}
}
\description{
Caterpillar plot of the posterior densities of a vector of parameter nodes,
in which the sequential order of nodes might not be important, such as vector of random effects.

This produces a set of overlayed interval bars (default values are 50 percent and 95 percent),
with overlayed median markings, for each of a vector of parameter nodes.
}
\examples{
## usage with input data.frame
a <- jags_df(asdf_jags_out, p="a")

caterpillar(a)
caterpillar(a, ci=seq(.1,.9,by=.1))
caterpillar(a, lwd=2)
caterpillar(a, xax=c("effect 1", "effect 2", "effect 3"))


## usage with input as jagsUI object
caterpillar(asdf_jags_out, p="a")
caterpillar(SS_out, p="rate")

## usage with a 2-d parameter matrix
caterpillar(SS_out, p="cycle_s", column=1)
caterpillar(SS_out, p="cycle_s", column=2)

## usage with an exponential transformation
caterpillar(SS_out, p="trend", transform="exp", ylab="exp transform")
caterpillar(SS_out, p="trend", transform="exp", ylab="exp transform", log="y")
caterpillar(SS_out, p="trend", transform="expit", ylab="expit (inv logit) transform")
}
\seealso{
\link{envelope}
}
\author{
Matt Tyers
}
