% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jagshelper1.R
\name{plotcor_jags}
\alias{plotcor_jags}
\title{Plot a correlation matrix from a JAGS object}
\usage{
plotcor_jags(
  x,
  p = NULL,
  exact = FALSE,
  mincor = 0,
  maxn = 4,
  maxcex = 1,
  legend = TRUE,
  ...
)
}
\arguments{
\item{x}{Output object returned from \code{jagsUI}}

\item{p}{Optional string to begin posterior names.  If \code{NULL} is used, all parameters will be used}

\item{exact}{Whether name must be an exact match (\code{TRUE}) or with initial sub-string matching only supplied characters (\code{FALSE}).
Defaults to \code{FALSE.}}

\item{mincor}{Minimum (absolute) correlation to use for text labels.  Defaults to 0 (all will be plotted)}

\item{maxn}{Maximum number of nodes per parameter name for text labels, to prevent plot clutter.  Defaults to 4.}

\item{maxcex}{Maximum character expansion factor for text labels.  Defaults to 1.}

\item{legend}{Whether to produce a plot legend.  Defaults to \code{TRUE}.}

\item{...}{Optional plotting arguments}
}
\value{
\code{NULL}
}
\description{
Plots a correlation matrix of all MCMC samples from an object
returned by 'jagsUI', or an optional subset of parameter nodes.  Correlation is
plotted as shades of red (positive) or blue (negative).

In the case of vectors or arrays of nodes for each parameter name, a single axis
tick will be used for all nodes with a single name.  This has the effect of
giving greater visual weight to single parameters, and reducing plot clutter.

Values of correlation are overlayed for all parameters with few nodes, with
character size scaled according to the absolute correlation.
}
\examples{
plotcor_jags(asdf_jags_out, maxcex=0.7)

plotcor_jags(SS_out, p=c("trend","rate","sig"))
}
\seealso{
\link{plotcor_jags}
}
\author{
Matt Tyers
}
