% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegularSamplingTimes.R
\name{regular_sampling_scheme}
\alias{regular_sampling_scheme}
\title{c/e rates for a regular sampling scheme}
\usage{
regular_sampling_scheme(x, vector, level = NULL, otus = NULL, int = NULL)
}
\arguments{
\item{x}{A single dataset.}

\item{vector}{A vector indicating the columns with presence-absence data.}

\item{level}{The name of the column with groups to calculate their c_e pair.}

\item{otus}{Minimal number of rows for each group}

\item{int}{Accuracy to calculate the c_e pairs with.}
}
\value{
A dataframe with colonization and extinction rates along with their
  associated transition probabilities or their lower and upper confidence
  intervals, for each group if specified.
}
\description{
\code{regular_sampling_scheme} calculates colonization and extinction rates
for a community or groups in a community.
}
\examples{
regular_sampling_scheme(alonso[[1]],3:6)
regular_sampling_scheme(alonso[[1]],3:6,"Guild",5)
regular_sampling_scheme(alonso[[1]],3:6,"Guild",5, 0.001)
}
\seealso{
\code{\link{irregular_single_dataset}},
  \code{\link{irregular_multiple_datasets}}
}

