% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfTransform}
\alias{ipfTransform}
\title{Transform function}
\usage{
ipfTransform(data, inRange = c(-100, 0), outRange = c(0, 100),
  inNoRSSI = NA, outNoRSSI = 0, trans = "linear", base = 10)
}
\arguments{
\item{data}{a vector, matrix or data frame containing the RSSI vectors}

\item{inRange}{a vector containing the range of the RSSI value from the
initial data}

\item{outRange}{the desired range for the output RSSI data.}

\item{inNoRSSI}{value used in the RSSI data to represent a not detected AP.}

\item{outNoRSSI}{value desired in the RSSI output data to represent a not detected AP.}

\item{trans}{the transformation to perform, 'linear' or 'exponential'}

\item{base}{base for the 'exponential' transformation}
}
\value{
This function returns a vector, matrix or data frame containing
        the transformed data
}
\description{
Transforms the RSSI (Received Signal Strength Intensity) data to positive
or exponential values
}
\examples{
    trainRSSI <- ipftrain[,1:168]
    ipfTransform(trainRSSI, inRange = c(-100, 0), outRange = c(1, 100),
                 inNoRSSI = NA, outNoRSSI = 0)

}
