% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_functions.R
\name{make_inlamemi_stacks}
\alias{make_inlamemi_stacks}
\title{Make data stacks for joint model specification in INLA}
\usage{
make_inlamemi_stacks(
  formula_moi,
  formula_imp,
  formula_mis = NULL,
  family_moi = "gaussian",
  data,
  error_type = "classical",
  error_variable = NULL,
  repeated_observations = FALSE,
  vars = NULL
)
}
\arguments{
\item{formula_moi}{an object of class "formula", describing the main model to be fitted.}

\item{formula_imp}{an object of class "formula", describing the imputation model for the mismeasured and/or missing observations.}

\item{formula_mis}{an object of class "formula", describing the missingness model. Does not need to have a response variable, since this will always be a binary missingness indicator.}

\item{family_moi}{a string indicating the likelihood family for the model of interest (the main model).}

\item{data}{an object of class data.frame or list containing the variables in the model.}

\item{error_type}{type of error (one or more of "classical", "berkson", "missing")}

\item{error_variable}{character vector with the name(s) of the variable(s) with error.}

\item{repeated_observations}{Does the variable with measurement error and/or missingness have repeated observations? If so, set this to "TRUE". In that case, when specifying the formula, use the name of the variable without any numbers, but when specifying the data, make sure that the repeated measurements end in a number, i.e "sbp1" and "sbp2".}

\item{vars}{Results from a call to "extract_variables_from_formula" function. If this is not passed as an argument, it is called inside the function.}
}
\value{
An object of class inla.stack with data structured according to specified formulas and error models.
}
\description{
Make data stacks for joint model specification in INLA
}
\examples{
\dontshow{if (requireNamespace('INLA')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
make_inlamemi_stacks(formula_moi = y ~ x + z,
                   formula_imp = x ~ z,
                   data = simple_data,
                   error_type = "classical")
\dontshow{\}) # examplesIf}
}
