% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteo_shortening.R
\name{meteo_shortening}
\alias{meteo_shortening}
\title{Shortening column names for meteorological variables}
\usage{
meteo_shortening(data, col_names = "short", remove_duplicates = TRUE)
}
\arguments{
\item{data}{downloaded dataset with original column names}

\item{col_names}{three types of column names possible: "short" - default, values with shorten names, "full" - full English description, "polish" - original names in the dataset}

\item{remove_duplicates}{whether to remove duplicated column names (default TRUE - i.e., columns with duplicated names are deleted)}
}
\description{
Shortening column names of meteorological parameters to improve the readability of downloaded dataset and removing duplicated column names
}
\examples{
\donttest{
  monthly <- meteo_monthly(rank = "climate", year = 1969)
  colnames(monthly)
  abbr <- meteo_shortening(data = monthly, col_names = "short", remove_duplicates = TRUE)
  head(abbr)
}

}
