% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\docType{methods}
\name{add_col_clusters}
\alias{add_col_clusters}
\alias{add_col_clusters,Iheatmap-method}
\title{add_col_clusters}
\usage{
\S4method{add_col_clusters}{Iheatmap}(p, clusters, name = "Col<br>Clusters",
  reorder = TRUE, side = c("top", "bottom"), xname = current_xaxis(p),
  ...)
}
\arguments{
\item{p}{iheatmap object}

\item{clusters}{cluster assignments, should be vector of integers, 
characters, or factors}

\item{name}{name of colorbar indicating cluster membership}

\item{reorder}{reorder rows based on clusters? default is TRUE}

\item{side}{side of plot on which to add subplot}

\item{xname}{name of xaxis}

\item{...}{additional arguments to pass to \code{\link{add_col_groups}} for 
creation of annotation heatmap indicating cluster membership}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Add column groups and order columns based on groups
}
\details{
This function is very similar to \code{\link{add_col_groups}}; the 
main difference is that with this function column will get reordered based on 
the groups.
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)
clusters <- c("A","B","A","B","A")

hm <- iheatmap(mat) \%>\% add_col_clusters(clusters)

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{add_row_clusters}}, \code{\link{add_col_clustering}}, 
\code{\link{iheatmap}}
}
\author{
Alicia Schep
}
